/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_ar_ctx.c,v 1.4 2005/03/15 19:56:10 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "qmgr.h"

/*
**  QAR_CTX_NEW -- Allocate a new QMGR - AR context
**
**	Parameters:
**		qmgr_ctx -- QMGR context
**		pqar_ctx -- QMGR - AR context (output)
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2003-10-17 03:23:14
*/

sm_ret_T
qar_ctx_new(qmgr_ctx_P qmgr_ctx, qar_ctx_P *pqar_ctx)
{
	qar_ctx_P qar_ctx;
	sm_ret_T ret;

	SM_IS_QMGR_CTX(qmgr_ctx);
	SM_REQUIRE(pqar_ctx != NULL);
	qar_ctx = (qar_ctx_P) sm_zalloc(sizeof(*qar_ctx));
	if (qar_ctx == NULL)
		return sm_error_temp(SM_EM_Q_Q2AR, ENOMEM);
	qar_ctx->qar_qmgr_ctx = qmgr_ctx;
	ret = sm_rcbcom_open(&(qar_ctx->qar_com));
	if (sm_is_err(ret))
		goto error;
	qar_ctx->sm_magic = SM_QAR_CTX_MAGIC;
	*pqar_ctx = qar_ctx;
	return SM_SUCCESS;

  error:
	SM_FREE_SIZE(qar_ctx, sizeof(*qar_ctx));
	return ret;
}

/*
**  QAR_CTX_FREE -- Free a QMGR - AR context
**
**	Parameters:
**		qar_ctx -- QMGR - AR context
**
**	Returns:
**		usual sm_error code (always SM_SUCCESS)
**
**	Locking: qar_ctx must be under control of the caller.
**
**	Last code review: 2003-10-17 03:23:14, see comments below
*/

sm_ret_T
qar_ctx_free(qar_ctx_P qar_ctx)
{
	if (qar_ctx == NULL)
		return SM_SUCCESS;
	(void) sm_rcbcom_close(&(qar_ctx->qar_com));
	SM_FREE_SIZE(qar_ctx, sizeof(*qar_ctx));
	return SM_SUCCESS;
}
