#!/bin/sh
# $Id: t-mapdom-0.sh,v 1.8 2004/12/29 20:53:14 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test lookup of domains.
# Uses t-mapdomr-0, t-mm
# ------------------------------------------------------------

test -s stop && exit 1
#

BDBIN="bdb2"
BDB="bdb2.db"
ERRS=0

cat > ${BDBIN} <<EOF
a.b.c		rhsabc
.b.c		rhsbc
.c		rhsc
.		dot
d.e		rhsde
e		rhse
Tag:.b.c		rhstagbc
.some.nice.domain	rhs-some.nice.domain
.nice.domain	rhs-nice.domain
.domain		rhs-domain
DomainTag:some.nice.domain	rhs-DomainTag:some.nice.domain
DomainTag:nice.domain		rhs-DomainTag:nice.domain
DomainTag:domain		rhs-DomainTag:domain
DomainTag:.nice.domain		rhs-DomainTag:.nice.domain
DomainTag:.domain		rhs-DomainTag:.domain
Default:.match		rhs-default:.match
Default:		rhs-default
EOF

# create map
rm -f ${BDB}
./t-mm -t'	' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

for P in ./t-mapdomr-0 # ./t-mapdom-0
do

# test full lookup
${P} "a.b.c" "rhsabc"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test subnet
${P} "x.b.c" "rhsbc"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test full lookup
${P} "c.d.e" ""
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test subnet and no match
${P} "x.y.c" "rhsc" "x.y.z" ""
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test tag (full, subnet, no match)
${P} "tag:a.b.c" "rhstagbc"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

${P} "domaintag:some.nice.domain" "rhs-DomainTag:some.nice.domain" \
	"domaintag:nice.domain" "rhs-DomainTag:nice.domain" \
	"domaintag:domain" "rhs-DomainTag:domain"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

${P} "domaintag:other.nice.domain" "rhs-DomainTag:.nice.domain" \
	"domaintag:other.not.domain" "rhs-DomainTag:.domain" \
	"domaintag:dom" ""
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test default
${P} "default:nomatch" "rhs-default" "default:a.match" "rhs-default:.match"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

done

exit ${ERRS}
