/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_init.c,v 1.10 2005/08/22 18:16:19 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/evthr.h"
#include "pmilter.h"

#if SM_USE_PMILTER
/*
**  SM_PMILT_INIT0 -- initialize PMILTER, step 0: set default values
**	invoked before command line options are read
**
**	Parameters:
**		ppmg_ctx -- (pointer to) pmilter (library) context (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmilt_init0(pmg_ctx_P *ppmg_ctx)
{
#if 0
	sm_ret_T ret;
#endif
	pmg_ctx_P pmg_ctx;

	SM_REQUIRE(ppmg_ctx != NULL);
	*ppmg_ctx = NULL;
	pmg_ctx = (pmg_ctx_P) sm_zalloc(sizeof(*pmg_ctx));
	if (pmg_ctx == NULL)
		return sm_error_temp(SM_EM_PMILTER, ENOMEM);

	/* clear out data */
	sm_memzero(pmg_ctx, sizeof(*pmg_ctx));

	/* initialize fds (0 could be valid hence they need to be set) */
	pmg_ctx->pmg_sslfd = INVALID_SOCKET;
	pmg_ctx->pmg_sockname = "pmilter.sock";

#if 0
	ret = sm_log_create(NULL, &(pmg_ctx->pmg_lctx),
				&(pmg_ctx->pmg_lcfg));
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init0, sm_log_create=%x\n", ret);
		goto error;
	}
	ret = sm_log_setfp_fd(pmg_ctx->pmg_lctx, smiolog, SMIOLOG_FILENO);
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init0, sm_log_setfp=%x\n", ret);
		goto error;
	}
	ret = sm_log_setdebuglevel(pmg_ctx->pmg_lctx,
				pmg_ctx->pmg_cnf.q_cnf_loglevel);
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init0, sm_log_setdebuglevel=%x\n",
			ret);
		goto error;
	}
#endif /* 0 */

	/* this is a bit early ... */
	pmg_ctx->sm_magic = SM_PMG_CTX_MAGIC;
	pmg_ctx->pmg_state = PMILT_ST_INIT0;
	*ppmg_ctx = pmg_ctx;
	return SM_SUCCESS;

#if 0
  error:
	return ret;
#endif /* 0 */
}

/*
**  SM_PMILT_INIT1 -- initialize PMILT
**	invoked after command line options are read
**
**	Parameters:
**		pmg_ctx -- pmilter (library) context
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmilt_init1(pmg_ctx_P pmg_ctx)
{
	int i;
	uint u;
	sm_ret_T ret;

	SM_IS_PMG_CTX(pmg_ctx);

	/* initialize pthreads */
	ret = thr_init();
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init, thr_init=%x\n", ret);
		goto error;
	}

	i = pthread_mutex_init(&(pmg_ctx->pmg_mutex), NULL);
	if (i != 0)
	{
		ret = sm_error_perm(SM_EM_Q, i);
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init, mutex_init=%x\n", i);
		goto error;
	}

	/* initialize event threads system; CONF */
	ret = evthr_init(&(pmg_ctx->pmg_ev_ctx), 2, 6, 10);
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init, evthr_init=%x\n", ret);
		goto error;
	}

#if 0
	ret = sm_log_setdebuglevel(pmg_ctx->pmg_lctx,
				pmg_ctx->pmg_cnf.q_cnf_loglevel);
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr,
			"sev=ERROR, func=sm_pmilt_init, sm_log_setdebuglevel=%x\n",
			ret);
		goto error;
	}
#endif /* 0 */

	/* create pmilter contexts */
	for (u = 0; u < SM_ARRAY_SIZE(pmg_ctx->pmg_sctx); u++)
	{
		ret = sm_pmss_new(pmg_ctx, &(pmg_ctx->pmg_sctx[u]));
		if (sm_is_err(ret))
		{
			sm_io_fprintf(smioerr,
				"sev=ERROR, func=sm_pmilt_init, sm_pmss_new=%m, u=%u\n",
				ret, u);
			goto error;
		}
	}

	pmg_ctx->pmg_state = PMILT_ST_INIT1;
	return SM_SUCCESS;

  error:
	/* XXX need to clean up... */
	return ret;
}
#endif /* SM_USE_PMILTER */
