/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_getmac.c,v 1.4 2005/06/21 17:46:06 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"

#if SM_USE_PMILTER
/*
**  SM_PMFI_GETMAC -- Get value for a macro
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		macro -- macro to retrieve
**		pvalue -- (pointer to) value of macro (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_getmac(pmse_ctx_P pmse_ctx, uint32_t macro, char **pvalue)
{
	int i;
	uint j;
	sm_str_P s;
	pmss_ctx_P pmss_ctx;

	if (pvalue == NULL)
		return sm_err_perm(EINVAL);
	SM_IS_PMSE_CTX(pmse_ctx);
	pmss_ctx = pmse_ctx->pmse_pmss_ctx;
	SM_IS_PMSS_CTX(pmss_ctx);
	*pvalue = NULL;

	for (i = PM_SMST_MAX - 1; i >=0 ; i--)
	{
		for (j = 0; j < PM_MAX_MACROS; j++)
		{
			if (pmss_ctx->pmss_mac_names[i][j] == macro)
			{

#if PM_SE_TA_ID_LOCAL
				/* HACK ahead! */
				if (macro == PMM_SEID)
				{
					*pvalue = pmse_ctx->pmse_se_id;
					return SM_SUCCESS;
				}
				if (macro == PMM_MAIL_TAID)
				{
					*pvalue = pmse_ctx->pmse_ta_id;
					return SM_SUCCESS;
				}
#endif /* PM_SE_TA_ID_LOCAL */

				s = pmse_ctx->pmse_mac_values[i][j];
				if (s != NULL)
					*pvalue = (char *) sm_str_getdata(s);
				return SM_SUCCESS;
			}
		}
	}
	return sm_err_perm(SM_E_NOTFOUND);
}
#endif /* SM_USE_PMILTER */
