/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: unixsockconn.c,v 1.4 2005/01/27 00:29:17 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/fcntl.h"
#include "sm/unixsock.h"

/*
**  UNIX_CLIENT_CONNECT -- Create a socket and connect it to a server.
**
**	Parameters:
**		name -- name of socket
**		pfd -- (pointer to) file descriptor (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
unix_client_connect(const char *name, int *pfd)
{
	int sockfd, err;
	struct sockaddr_un addr;

	SM_REQUIRE(name != NULL);
	SM_REQUIRE(pfd != NULL);

	*pfd = INVALID_SOCKET;
	sockfd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sockfd == -1)
		return sm_error_perm(SM_EM_NET, errno);	/* perm/temp? */
	sm_memset(&addr, '\0', sizeof(addr));
	addr.sun_family = AF_UNIX;
	if (strlcpy(addr.sun_path, name, sizeof addr.sun_path)
	    >= sizeof addr.sun_path)
		return sm_error_perm(SM_EM_NET, SM_E_2BIG);
#if HAVE_SOCK_UN_SUN_LEN
	addr.sun_len = strlen(name);
#endif

	if ((connect(sockfd, (struct sockaddr *) &addr, sizeof(addr))) == -1)
	{
		err = sm_error_perm(SM_EM_NET, errno);	/* perm/temp? */
		close(sockfd);
		return err;
	}
	*pfd = sockfd;
	return SM_SUCCESS;
}
