/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: streq.c,v 1.4 2002/08/27 04:03:04 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_EQ -- Compare two strings.
**
**	Parameters:
**		s1 -- first string.
**		s2 -- second string.
**
**	Returns:
**		0: strings are equal
**		!=0: otherwise
*/

bool
sm_str_eq(const sm_str_P s1, const sm_str_P s2)
{
	SM_IS_BUF(s1);
	SM_IS_BUF(s2);
	if (s1->sm_str_len != s2->sm_str_len)
		return false;
	return sm_memeq(s1->sm_str_base, s2->sm_str_base, s1->sm_str_len);
}
