/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: childstatus.c,v 1.1 2005/01/10 03:02:12 ca Exp $")

#include "sm/types.h"
#include "sm/signal.h"
#include "sm/wait.h"
#include "sm/sysexits.h"

/*
**  SM_CHILD_STATUS -- decode child status
**
**	Parameters:
**		status -- return status (achieved via wait())
**
**	Returns:
**		type of failure (see wait.h)
*/

int
sm_child_status(int status)
{
	int k, failtype;

	/* default return value */
	failtype = SM_FAILED_IGNORE;
	if (status == 0)
		return failtype;
	if (WIFEXITED(status))
	{
		k = WEXITSTATUS(status);
		switch (k)
		{
		  /* don't count these as failures */
		  case EX_DATAERR:
		  case EX_NOINPUT:
		  case EX_NOUSER:
		  case EX_NOHOST:
		  case EX_OSERR:
		  case EX_OSFILE:
		  case EX_CANTCREAT:
		  case EX_IOERR:
		  case EX_TEMPFAIL:
		  case EX_PROTOCOL:
			break;

		  /* don't try to restart on these errors */
		  case EX_USAGE:
		  case EX_CONFIG:
			failtype = SM_FAILED_STOP;
			break;
		  default:
			failtype = SM_FAILED_COUNT;
			break;
		}
	}
	else if (WIFSIGNALED(status))
	{
		k = WTERMSIG(status);
		switch (k)
		{
		  /* don't count these as failures */
		  case SIGHUP:
		  case SIGINT:
		  case SIGPIPE:
			break;
		  default:
			failtype = SM_FAILED_COUNT;
			break;
		}
	}
	return failtype;
}
