/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: ibdbh.c,v 1.9 2005/01/11 23:51:00 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "sm/cstr.h"
#include "sm/ibdb.h"

/*
**  IBDBR_RCPT_FREE -- free a single recipient address
**
**	Parameters:
**		ibdbr_rcpt -- IBDB recipient
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
ibdbr_rcpt_free(ibdb_rcpt_P ibdb_rcpt)
{
	if (ibdb_rcpt == NULL)
		return SM_SUCCESS;
	SM_FREE(ibdb_rcpt->ibr_ta_id);
	SM_STR_FREE(ibdb_rcpt->ibr_pa);
	sm_free_size(ibdb_rcpt, sizeof(*ibdb_rcpt));
	return SM_SUCCESS;
}

/*
**  IBDBR_RCPT_NEW -- allocate a new recipient
**
**	Parameters:
**		pibdb_rcpt -- recipient (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
ibdbr_rcpt_new(ibdb_rcpt_P *pibdb_rcpt)
{
	ibdb_rcpt_P ibdb_rcpt;

	ibdb_rcpt = NULL;
	ibdb_rcpt = (ibdb_rcpt_P) sm_zalloc(sizeof(*ibdb_rcpt));
	if (ibdb_rcpt == NULL)
		goto enomem;
	ibdb_rcpt->ibr_pa = sm_str_new(NULL, MAXADDRLEN, MAXADDRLEN + 4);
	if (ibdb_rcpt->ibr_pa == NULL)
		goto enomem;
	ibdb_rcpt->ibr_ta_id = (char *) sm_malloc(SMTP_STID_SIZE + 1);
	if (ibdb_rcpt->ibr_ta_id == NULL)
		goto enomem;
	*pibdb_rcpt = ibdb_rcpt;
	return SM_SUCCESS;

  enomem:
	ibdbr_rcpt_free(ibdb_rcpt);
	*pibdb_rcpt = NULL;
	return sm_error_temp(SM_EM_IBDB, ENOMEM);
}

/*
**  IBDBR_TA_FREE -- free a transaction
**
**	Parameters:
**		ibdb_ta -- IBDB transaction
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
ibdbr_ta_free(ibdb_ta_P ibdb_ta)
{
	if (ibdb_ta == NULL)
		return SM_SUCCESS;
	SM_FREE(ibdb_ta->ibt_ta_id);
	SM_STR_FREE(ibdb_ta->ibt_mail_pa);
	SM_CSTR_FREE(ibdb_ta->ibt_cdb_id);
	sm_free_size(ibdb_ta, sizeof(*ibdb_ta));
	return SM_SUCCESS;
}

/*
**  IBDBR_TA_NEW -- create new transaction
**
**	Parameters:
**		pibdb_ta -- pointer to IBDB transaction (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
ibdbr_ta_new(ibdb_ta_P *pibdb_ta)
{
	ibdb_ta_P ibdb_ta;

	ibdb_ta = (ibdb_ta_P) sm_zalloc(sizeof(*ibdb_ta));
	if (ibdb_ta == NULL)
		goto enomem;

	ibdb_ta->ibt_mail_pa = sm_str_new(NULL, MAXADDRLEN, MAXADDRLEN + 4);
	if (ibdb_ta->ibt_mail_pa == NULL)
		goto enomem;
	ibdb_ta->ibt_ta_id = (char *) sm_malloc(SMTP_STID_SIZE + 1);
	if (ibdb_ta->ibt_ta_id == NULL)
		goto enomem;

	*pibdb_ta = ibdb_ta;
	return SM_SUCCESS;

  enomem:
	/* clean up... */
	(void) ibdbr_ta_free(ibdb_ta);
	*pibdb_ta = NULL;
	return sm_error_temp(SM_EM_IBDB, ENOMEM);
}

