/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-txn-0.c,v 1.4 2005/03/15 19:56:05 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/signal.h"
#include "sm/str.h"
#include "sm/io.h"
#include "sm/test.h"
#include "sm/edb.h"
#include "sm/edbcnf.h"
#include "sm/actdb-int.h"
#define QMGR_DEBUG_DEFINE 1
#include "sm/qmgrdbg.h"
#include "edb-int.h"

static sm_ret_T
chg_ta(aq_ta_P aq_ta, int ta, int pid, int index)
{
	sessta_id_T ta_id;
	sm_str_P str;
	sm_ret_T ret;
	char mail_pa[256];

	/* lots of stuff just to get a valid aq_ta entry... */
	ret = SM_SUCCESS;
	sm_snprintf(ta_id, sizeof(ta_id), SMTPS_STID_FORMAT,
		(ulonglong_T) ta, pid);

	SESSTA_COPY(aq_ta->aqt_ss_ta_id, ta_id);
	sm_snprintf(mail_pa, sizeof(mail_pa), "<x-%d@y.z>", index);
	str = sm_str_scpy0(NULL, mail_pa, 256);
	aq_ta->aqt_mail->aqm_pa = str;
	aq_ta->aqt_st_time = 123457;

	aq_ta->aqt_rcpts_tot = 4;	/* total number recipients */
	aq_ta->aqt_rcpts_left = 4;	/* rcpts still to deliver */
	aq_ta->aqt_rcpts_temp = 1;
	aq_ta->aqt_rcpts_perm = 0;
	aq_ta->aqt_rcpts_ar = 4;
	aq_ta->aqt_state = 400;
	aq_ta->aqt_cdb_id = sm_cstr_scpyn((const uchar *) ta_id, SMTP_STID_SIZE);
	SM_TEST(aq_ta->aqt_cdb_id != NULL);
	return ret;
}

static aq_ta_P
new_ta(void)
{
	aq_ta_P aq_ta;

	aq_ta = (aq_ta_P) sm_zalloc(sizeof(*aq_ta));
	SM_TEST(aq_ta != NULL);
	if (aq_ta == NULL)
		return NULL;
	aq_ta->aqt_mail = (aq_mail_P) sm_malloc(sizeof(*(aq_ta->aqt_mail)));
	SM_TEST(aq_ta->aqt_mail != NULL);
	if (aq_ta->aqt_mail == NULL)
		return NULL;
#if AQ_TA_CHECK
	aq_ta->sm_magic = SM_AQ_TA_MAGIC;
#endif /* AQ_TA_CHECK */
	return aq_ta;
}

static void
free_ta(aq_ta_P aq_ta)
{
	if (aq_ta == NULL)
		return;
	if (aq_ta->aqt_mail != NULL)
	{
		SM_STR_FREE(aq_ta->aqt_mail->aqm_pa);
		SM_FREE(aq_ta->aqt_mail);
	}
	SM_CSTR_FREE(aq_ta->aqt_cdb_id);
	sm_free(aq_ta);
}

static void
txn0()
{
	sm_ret_T ret;
	edb_ctx_P edb_ctx;
	aq_ctx_P aq_ctx;
	aq_ctx_T aq_ctx_s;
	aq_ta_P aq_ta;
	edb_req_P edb_req;

	edb_ctx = NULL;
	aq_ctx = &aq_ctx_s;
	edb_req = NULL;
	aq_ta = NULL;
	ret = edb_open(NULL, NULL, &edb_ctx);
	SM_TEST(ret == SM_SUCCESS);
	if (sm_is_err(ret))
		return;
	ret = aq_open(NULL, &aq_ctx, 256, 0);
	SM_TEST(ret == SM_SUCCESS);
	if (sm_is_err(ret))
		goto error;
	aq_ta = new_ta();
	SM_TEST(aq_ta != NULL);
	if (aq_ta == NULL)
		goto error;

	ret = chg_ta(aq_ta, 0, 1, 0);
	SM_TEST(ret == SM_SUCCESS);
	ret = edb_ta_app(edb_ctx, aq_ta, NULL, 450);
	SM_TEST(ret == SM_SUCCESS);
	ret = edb_wr_status(edb_ctx, NULL);
	SM_TEST(ret == SM_SUCCESS);
	if (sm_is_err(ret))
		goto error;

	free_ta(aq_ta);

	/* commit suicide */
	kill(0, SIGTERM);

	return;

  error:
	/* always close db */
	ret = edb_close(edb_ctx);
	SM_TEST(ret == SM_SUCCESS);
	return;
}

int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "")) != -1)
	{
		switch (c)
		{
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	sm_test_begin(argc, argv, "test txn 0");

	/* Ignore result, directory may already exist */
	(void) mkdir(EDB_HOME, 0700);
	txn0();
	return sm_test_end();
}
