#!/bin/sh
# $Id: t-conf-0.sh,v 1.3 2004/12/29 20:53:12 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=sm0.conf
OUT=sm0.out
OK=sm0.ok

PRG=./t-conf-0

cat > ${CNF} <<EOF
socket = "/some/socket";

nameserver = 10.1.2.46;

flags = {flag2,  flag1, };

qmgr {
        limit = 5;
        listen MTA { type=inet; port=25; address=10.1.2.3; };
        listen MSA { type=inet; port=587; address=20.10.20.30; };
}
EOF

cat > ${OK} <<EOF
value= 0
limit= 5
duration= 0
socket= "/some/socket"
flags= 3
nameserver= 10.1.2.46

sockspec= struct
name= (none)
type= 1
port= 25
host= "(NULL)"
address= 10.1.2.3


sockspec= struct
name= (none)
type= 1
port= 587
host= "(NULL)"
address= 20.10.20.30

opt=qmgr.limit, conf_get=0, text=OK

sockspec= loop
name= MTA
type= 1
port= 25
host= "(NULL)"
address= 10.1.2.3


sockspec= loop
name= MSA
type= 1
port= 587
host= "(NULL)"
address= 20.10.20.30

EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
