#!/bin/sh
# $Id: t-all.sh,v 1.4 2004/12/29 20:53:12 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Run all t-prog-*.in tests, compare their results against
# t-prog-*.ok, and complain if the results don't match.
# ------------------------------------------------------------
#

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`
TST="${SD}"

ERRS=0
VERBOSE=false

# works only with ksh on OSF/1
if test X"`uname`" != "XOSF1"
then
while getopts v FLAG
do
  case "${FLAG}" in
    v)
	VERBOSE=true
       ;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "usage: $0 [options]"
       echo "$0: options:"
       echo "-v     verbose"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

TESTS="${TST}"/t-*.in
if test $# -ge 1
then
  TESTS=$@
fi

for i in ${TESTS}
do
	BASE=`echo "${i}" | sed 's,.*/\(t-[^/]*\)$,\1,'`
	PROG=`echo "${BASE}" | sed 's,t-\(.*\)-[a-zA-Z0-9_]*\.in,\1,'`
	CASE=`echo "${BASE}" | sed 's,t-.*-\([a-zA-Z0-9_]*\)\.in,\1,'`

	${VERBOSE} && echo "" | awk '{ printf("%s: ", "'"${BASE}"'"); }'

	./${PROG} < "${i}" > t-"${PROG}"-"${CASE}".out 2>&1
	if cmp t-"${PROG}"-"${CASE}".out "${TST}"/t-"${PROG}"-"${CASE}".ok
	then 
		${VERBOSE} && echo ok.
		rm t-"${PROG}"-"${CASE}".out
	else
		ERRS=`expr ${ERRS} + 1 `
	fi
done
exit ${ERRS}
