/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm-conf-null.c,v 1.2 2005/02/18 02:33:56 ca Exp $")

#if SM_LIBCONF_ALONE
#include <string.h>

#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/string.h"
#include "sm/memops.h"
#include "sm/sm-conf.h"
#endif /* SM_LIBCONF_ALONE */
#include "sm-conf-scan.h"
#include "sm-conf-state.h"
#include "sm-conf-type.h"

/*
**  SM_CONF_NULL -- populate a structure with default values.
**
**	Ignoring the parse tree in <handle>, use the the data
**	and callbacks in <definitions> to initialize the
**	struct(s) pointed to by <data>.
**
**	It is legal for the result of this pass to not be
**	consistent with the per-node check functions; this is
**	only the basis of a later stage.
**
**	Parameters:
**		handle -- the overall handle of the configuration
**			file parser.
**		definitions -- list of names and their meanings.
**			If it starts with a node whose name is "",
**			it's a definition for the whole node;
**			otherwise, the node must be a section, and
**			the definitions are for the section contents.
**		flags -- parameters of the node as a whole
**		data -- base pointer of a structure  into which
**			values are copied.
*/

int
sm_conf_null(
	sm_conf_T			*handle,
	sm_conf_definition_T const	*definitions,
	unsigned int			flags,
	void				*data)
{
	sm_conf_definition_T		section_def[2];

	if (handle == NULL)
		return SM_CONF_ERR_INVALID;

	if (definitions == NULL || definitions->scd_name == NULL)
		return SM_CONF_ERR_INVALID;

	if (definitions->scd_name[0] != '\0')
	{
		sm_memset(&section_def, 0, sizeof section_def);
		section_def[0].sm_magic = SM_CONF_DEF_MAGIC;
		section_def[0].scd_name = "";
		section_def[0].scd_type = sm_conf_type_section;
		section_def[0].scd_default = NULL;
		section_def[0].scd_flags = flags;
		section_def[0].scd_contents = definitions;
		section_def[1].scd_name = NULL;

		definitions = section_def;
	}

	return (* definitions->scd_type->sctp_value_null)(handle,
		definitions, data);
}

