/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rcbl.h,v 1.10 2005/10/24 22:43:18 ca Exp $
 */

#ifndef SM_RCBL_H
#define SM_RCBL_H 1
#include "sm/generic.h"
#include "sm/types.h"
#include "sm/queue.h"
#include "sm/rcb.h"

typedef sm_ret_T	(*rcb_wr_cb_F)(void *_ctx);

/* RCB entry (in a list/simple queue) */
typedef	struct sm_rcbe_S	sm_rcbe_T, *sm_rcbe_P;

/* head for rcb list */
SIMPLEQ_HEAD(sm_rcbh_S, sm_rcbe_S);
typedef	struct sm_rcbh_S	sm_rcbh_T, *sm_rcbh_P;

struct sm_rcbe_S
{
	/* XXX this may cause problems for the free() operation! */
	sm_rcb_T			 rcbe_rcb;	/* rcb */

	/* application context for callback function */
	void				*rcbe_ctx;

	/* callback to invoke after a successful rcb_snd() */
	rcb_wr_cb_F			 rcbe_wr_cb;

	/* link to next RCB entry */
	SIMPLEQ_ENTRY(sm_rcbe_S)	 rcbe_next;
};

#define RCBL_INIT(rcbh)		SIMPLEQ_INIT(rcbh)
#define RCBL_FIRST(rcbh)	SIMPLEQ_FIRST(rcbh)
#define RCBL_END(rcbh)		SIMPLEQ_END(rcbh)
#define RCBL_EMPTY(rcbh)	SIMPLEQ_EMPTY(rcbh)
#define RCBL_NEXT(rcbe)		SIMPLEQ_NEXT(rcbe, rcbe_next)
#define RCBL_APP(rcbh, rcbe)	SIMPLEQ_INSERT_TAIL(rcbh, rcbe, rcbe_next)
#define RCBL_REMOVE(rcbh)	SIMPLEQ_REMOVE_HEAD(rcbh, rcbe_next)

#define SM_IS_RCBE(rcbe)	SM_ASSERT((rcbe) != NULL)

sm_rcbe_P sm_rcbe_new(sm_rpool_P _rpool, uint _len, uint _max);
void	 sm_rcbe_free(sm_rcbe_P _rcbe);
void	 sm_rcbe_setcb(sm_rcbe_P _rcbe, rcb_wr_cb_F _wr_cb, void *_ctx);

#endif /* SM_RCBL_H */
