/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: mapcnf.h,v 1.12 2005/08/14 06:32:10 ca Exp $
 */

#ifndef SM_MAPCNF_H
#define SM_MAPCNF_H 1

#include "sm/generic.h"
#include "sm/net.h"
#include "sm/map.h"

/*
**  Problem: different maps need different parameters for open:
**  socketmap: use sockcnfdef?
**  sequence map: array of names?
**  hash: optional parameters, e.g., cache size?
**  should this be a union?
*/

enum mapspec_kind_E
{
	  MST_HASH	= 1
	, MST_SOCKET	= 2
	, MST_SEQUENCE	= 3
	, MST_PASSWD	= 4
	, MST_BHT	= 5
} mapspec_kind;
typedef enum mapspec_kind_E mapspec_kind_T;

#define SM_MAPSPEC(what)	\
	mapspec_kind_T		 mst_##what##_kind;	\
	sm_map_P		 mst_##what##_map;	\
	char			*mst_##what##_name;	\
	char			*mst_##what##_type

#define SM_MAPSPEC_FL_IMPLDET	0x00000001u

struct mst_generic_S
{
	SM_MAPSPEC(generic);
};
typedef struct mst_generic_S mst_generic_T;

struct mst_hash_S
{
	SM_MAPSPEC(hash);
	char			*mst_hash_fn;
	char			*mst_hash_path;
};
typedef struct mst_hash_S mst_hash_T;

struct mst_bht_S
{
	SM_MAPSPEC(bht);
	char			*mst_bht_fn;
	char			*mst_bht_path;
};
typedef struct mst_bht_S mst_bht_T;

struct mst_socket_S
{
	SM_MAPSPEC(socket);
	char			*mst_socket_mapname;
	char			*mst_socket_path;
	ipv4_T			 mst_socket_ipv4;
	short			 mst_socket_port;
	sm_intvl_T		 mst_socket_tmout;
};
typedef struct mst_socket_S mst_socket_T;

struct mst_seq_S
{
	SM_MAPSPEC(seq);
	char			**mst_seq_maps;
};
typedef struct mst_seq_S mst_seq_T;

struct mst_passwd_S
{
	SM_MAPSPEC(passwd);
};
typedef struct mst_passwd_S mst_passwd_T;

union mapspec_U
{
	mapspec_kind_T		 mst_kind;

	mst_generic_T		 mst_generic;
#define mst_name mst_generic.mst_generic_name
#define mst_type mst_generic.mst_generic_type

	mst_hash_T		 mst_hash;
	mst_bht_T		 mst_bht;
	mst_socket_T		 mst_socket;
	mst_seq_T		 mst_seq;
	mst_passwd_T		 mst_passwd;
};

typedef union mapspec_U mapspec_T, *mapspec_P;

struct map_decl_S
{
	mapspec_T	*mapdecl_maps;
	uint		 mapdecl_n;
};
typedef struct map_decl_S map_decl_T, *map_decl_P;


#endif /* SM_MAPCNF_H */
