/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: common.h,v 1.4 2005/10/25 00:00:04 ca Exp $
 */

/*
**  Common definitions for smX modules
*/

#ifndef SM_COMMON_H
#define SM_COMMON_H 1
#include "sm/generic.h"

/* -V: show configuration data */
#define SM_SV_VERSION	1	/* version of module */
#define SM_SV_LIBS	2	/* library versions */
#define SM_SV_OPTIONS	3	/* compile time options */
#define SM_SV_RD_CONF	4	/* configuration data as read from conf file */
#define SM_SV_DFLT_CONF	5	/* default configuration data */
#define SM_SV_ALL_CONF	6	/* all configuration data */

#define SM_SHOW_VERSION(level)		((level) >= SM_SV_VERSION)
#define SM_SHOW_LIBS(level)	\
	((level) >= SM_SV_LIBS && (level) < SM_SV_RD_CONF)
#define SM_SHOW_OPTIONS(level)	\
	((level) >= SM_SV_OPTIONS && (level) < SM_SV_RD_CONF)
#define SM_SHOW_RD_CONF(level)		((level) == SM_SV_RD_CONF)
#define SM_SHOW_DFLT_CONF(level)	((level) == SM_SV_DFLT_CONF)
#define SM_SHOW_ALL_CONF(level)	((level) == SM_SV_ALL_CONF)


#define SM_DONTRUNASROOT  "sev=FATAL, prg=%s, status=do not run as root!"

/* limit for total number of A records (currently compile time only) */
#ifndef SM_DNS_A_MAX
# define SM_DNS_A_MAX	100
#endif

#endif /* SM_COMMON_H */
