/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: aqtacnts.h,v 1.2 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_AQCNTS_H
#define SM_AQCNTS_H 1

#include "sm/generic.h"
#include "sm/types.h"

/*
**   structure to save counters from aq_ta that are modified by
**	aq_upd_ta_rcpt_cnts())
*/

typedef struct aq_tacnts_S	aq_tacnts_T, *aq_tacnts_P;
struct aq_tacnts_S
{
	uint		 aqtc_temp;
	uint		 aqtc_perm;
	uint		 aqtc_tried;
	uint		 aqtc_left;
};

sm_ret_T aq_save_ta_rcpt_cnts(aq_ta_P _aq_ta, aq_tacnts_P _aq_tacnts);
sm_ret_T aq_restore_ta_rcpt_cnts(aq_ta_P _aq_ta, aq_tacnts_P _aq_tacnts);

/* the next two macros require aq_tacnts to be of type aq_tacnts_T */
#define AQ_SAVE_TA_RCPT_CNTS(aq_ta, aq_tacnts)	do			\
	{								\
		(aq_tacnts).aqtc_tried = (aq_ta)->aqt_rcpts_tried;	\
		(aq_tacnts).aqtc_left = (aq_ta)->aqt_rcpts_left;	\
		(aq_tacnts).aqtc_perm = (aq_ta)->aqt_rcpts_perm;	\
		(aq_tacnts).aqtc_temp = (aq_ta)->aqt_rcpts_temp;	\
	} while (0)

#define AQ_RESTORE_TA_RCPT_CNTS(aq_ta, aq_tacnts)	do		\
	{								\
		(aq_ta)->aqt_rcpts_tried = (aq_tacnts).aqtc_tried;	\
		(aq_ta)->aqt_rcpts_left = (aq_tacnts).aqtc_left;	\
		(aq_ta)->aqt_rcpts_perm = (aq_tacnts).aqtc_perm;	\
		(aq_ta)->aqt_rcpts_temp = (aq_tacnts).aqtc_temp;	\
	} while (0)

#define SM_IS_AQ_TACNTS(aq_tacnts) SM_REQUIRE((aq_tacnts) != NULL)

#endif /* SM_AQCNTS_H */
