#!/bin/sh
# $Id: t-smtpf2.sh,v 1.18 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling from different components
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
EDBROK="../qmgr/t-smtpf2-edbr.ok"
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

TEST=1
# ----------------------------------------
# permanent failure from SMTP sink data dot

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<f2s2@b.c>
	rcpts_tot=4
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=1
	state=551
	aqt_rcpts_ar=0
got recipient
	rcpt=<451@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=451
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Q '-P<bounce@y.z>' -Y '-F 551' -O ${EDBROK} -E 4 -A 1 -X 0 -S"f2s2@b.c" -R"f2ok1@y.z -R451@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


TEST=2
# ----------------------------------------
# temporary failure from SMTP sink data dot.
# no mail can be delivered because of that.
# one OK recipient fails in final dot, the other two fail earlier.
# 553@ causes a bounce which can't be delivered either.

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<f2s3@b.c>
	rcpts_tot=4
	rcpts_left=3
	rcpts_temp=3
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<f2ok3@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=451
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=452
got recipient
	rcpt=<f2s3@b.c>
	aqr_rcpt_idx=3
	aqr_da_idx=0
	aqr_status=451
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -s 10 -Q '-P<bounce@y.z>' -Y '-F 451' -O ${EDBROK} -E 4 -A 1 -X 0 -S"f2s3@b.c" -R"f2ok3@y.z -R452@y.z -R553@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


TEST=3
# ----------------------------------------
# permanent failure from SMTP sink data dot, no mail can be delivered.

${CAT} > ${EDBROK} <<EOF
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Q '-P<bounce@y.z>' -Y '-F 551' -O ${EDBROK} -E 3 -A 1 -X 0 -S"f2s4@b.c" -R"f2ok4@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=4
# ----------------------------------------
# temporary failure from SMTP sink data dot, no mail can be delivered.

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<f2s5@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<f2ok5@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=451
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Q '-P<bounce@y.z>' -Y '-F 451' -O ${EDBROK} -E 1 -A 1 -X 0 -S"f2s5@b.c" -R"f2ok5@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=5
# ----------------------------------------
# permanent failure from SMTP DATA data (first try only)

${CAT} > ${EDBROK} <<EOF
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Q '-P<bounce@y.z>' -Y '-A 551 -r 1' -O ${EDBROK} -E 2 -A 1 -X 0 -S"f2s5@b.c" -R"f2ok5@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=6
# ----------------------------------------
# temporary failure from SMTP sink data dot.
# no mail can be delivered because of that.
# one OK recipient fails in final dot, another fails earlier.

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<f2s6@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<f2ok6@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=451
got recipient
	rcpt=<452@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=452
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -s 10 -Q '-P<bounce@y.z>' -Y '-F 451' -O ${EDBROK} -E 2 -A 1 -X 0 -S"f2s6@b.c" -R"f2ok6@y.z -R452@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi



# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${EDBROK}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
