#!/bin/sh
# $Id: t-minta-0.sh,v 1.12 2005/07/21 22:07:38 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test program running the full system, uses mcpmts.sh
# test scheduler: does it "coalesce" recipients (i.e., rcpts with same
# domain part into a single DA TA)?
# uses connect_only_to = 127.0.0.1; for smtpc which doesn't work with
# FreeBSD jails.
# ----------------------------------------
#
test -s stop && exit 1
#

# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

# cd to right directory
cd ../qmgr || exit 1

SHELL=/bin/sh
test -x /bin/ksh && SHELL=/bin/ksh

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

# ----------------------------------------
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 12; pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc { log_level = 12; remote_port = ${SNKPORT}; wait_for_server=4;
	connect_only_to = 127.0.0.1;
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF}";
}
qmgr { log_level = 12; wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF}";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

${CAT} > ${MT} <<EOF
dom1.tld	[10.1.1.1]
dom2.tld	[10.1.1.2]
dom3.tld	[10.1.1.3]
dom4.tld	[10.1.1.4]
dom5.tld	[10.1.1.5]
dom6.tld	[10.1.1.6]
dom7.tld	[10.1.1.7]
dom8.tld	[10.1.1.8]
dom9.tld	[10.1.1.9]
EOF

for i in smar smtps smtpc qmgr
do
  cp /dev/null ${i}.log
done

# ----------------------------------------
${SHELL} ${SD}/mcpmts.sh -x1 -E2 -1 -Sdom1-s@dom1.tld -R"dom1-a@dom1.tld -Rdom1-b@dom1.tld" || exit 1

${SHELL} ${SD}/mcpmts.sh -x2 -E4 -1 -Sdom1-s@dom1.tld -Rdom1-a@dom1.tld -Rdom1-b@dom1.tld -Rdom2-a@dom2.tld -Rdom2-b@dom2.tld || exit 1

${SHELL} ${SD}/mcpmts.sh -x3 -E5 -1 -Sdom1-s@dom1.tld -Rdom1-a@dom1.tld -Rdom3-a@dom3.tld -Rdom1-b@dom1.tld -Rdom2-a@dom2.tld -Rdom2-b@dom2.tld || exit 1

${SHELL} ${SD}/mcpmts.sh -x4 -E6 -1 -Sdom1-s@dom1.tld -Rdom1-a@dom1.tld -Rdom3-a@dom3.tld -Rdom1-b@dom1.tld -Rdom2-a@dom2.tld -Rdom5-a@dom5.tld -Rdom2-b@dom2.tld || exit 1

rm -f ${MTMAP}

exit 0
