#!/bin/sh
# $Id: t-bounce-2.sh,v 1.20 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-2.ok"
OUT="t-bounce-2.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
550: local:
551: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# ----------------------------------------
# double bounce;
# permanent failure from SMTP sink; check content
TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Double Bounce
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I couldn't deliver a bounce message;
see below for details.

Recipient:
<551@local.host>
Remote-MTA: 127.0.0.1
Reason:
550 whatever
during MAIL



Original bounce message follows:
Recipient:
<550@local.dom>
Remote-MTA: ${SM_LMTPIPV4D}
Reason:
550 whatever
EOF

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -S550@local.dom -R"551@local.host" -i 10 -E 0 -X 1 -A 1 -s 10 -Q '-P <sender@local.dom>'
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^during RCPT/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
