#!/bin/sh
# $Id: t-t2822-0.sh,v 1.11 2005/04/10 23:44:41 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
#
IN=t2822_parse.in
O=t2822_parse.out
OUT=t2822_parse.fil
ERRORS=0
./t-t2822-0 > ${O} 2>&1 <<EOF
sm9@sendmail.org
"sm9 mta"@sendmail.org
sm9@sendmail.org
sm9 @ sendmail.org
("sm9 ) mta") <"sm9 mta"@sendmail.org>
"sm9 mta" <sm9@sendmail.org>
( ("sm9 ) mta") ) <"sm9 mta"@sendmail.org>
"sm9 mta"@sendmail.org
sm9\ mta@sendmail.org
"sm9 mta
sm9@[stuff
sm9@["stuff]
named group: foo@bar, baz@barf;
sm9@foo (sm9
        mta)
EOF
# filter output data: get rid of paths
sed -e 's/ .*t-t2822-0/ t-t2822-0/' ${O} > ${OUT}
cat > ${IN} <<EOF
>>>sm9@sendmail.org<<<
sm9@sendmail.org
>>>"sm9 mta"@sendmail.org<<<
"sm9 mta"@sendmail.org
>>>sm9@sendmail.org<<<
sm9@sendmail.org
>>>sm9 @ sendmail.org<<<
sm9@sendmail.org
>>>("sm9 ) mta") <"sm9 mta"@sendmail.org><<<
19..bad! t-t2822-0.c:98 r == 1
>>>("sm9 ) mta") <"sm9 mta"@sendmail.org><<<	FAILED
>>>"sm9 mta" <sm9@sendmail.org><<<
"sm9 mta" <sm9@sendmail.org>
>>>( ("sm9 ) mta") ) <"sm9 mta"@sendmail.org><<<
25..bad! t-t2822-0.c:98 r == 1
>>>( ("sm9 ) mta") ) <"sm9 mta"@sendmail.org><<<	FAILED
>>>"sm9 mta"@sendmail.org<<<
"sm9 mta"@sendmail.org
>>>sm9\ mta@sendmail.org<<<
"sm9 mta"@sendmail.org
>>>"sm9 mta<<<
35..bad! t-t2822-0.c:98 r == 1
>>>"sm9 mta<<<	FAILED
>>>sm9@[stuff<<<
37..bad! t-t2822-0.c:98 r == 1
>>>sm9@[stuff<<<	FAILED
>>>sm9@["stuff]<<<
sm9@[\\"stuff]
>>>named group: foo@bar, baz@barf;<<<
named group: foo@bar, baz@barf;
>>>sm9@foo (sm9
        mta)<<<
sm9@foo (sm9\\
        mta)
EOF
diff ${OUT} ${IN}
if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1 `
fi
if test ${ERRORS} -eq 0
then
  rm -f ${IN} ${OUT} ${O}
fi
exit ${ERRORS}
