/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-stthreadssignal.c,v 1.1 2005/01/09 03:34:58 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/types.h"
#include "sm/signal.h"
#include "statethreads/st.h"
#include "sm/io.h"
#include "sm/test.h"

st_netfd_t Sig_pipe[2];


static int Verbose;

static sm_ret_T
t_stthreadssignal(void)
{
	sm_ret_T ret;
	char sig;
	uint signalset;

	signalset = SM_HDL_SIG_TERM|SM_HDL_SIG_USR1|SM_HDL_SIG_USR2;
	ret = st_install_sighandlers(signalset, NULL, NULL);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		goto error;

	do
	{
		ret = st_read(Sig_pipe[0], &sig, sizeof(char), (st_utime_t)-1);
		SM_TEST(ret == sizeof(char));

		switch (sig)
		{
		  case SM_SIG_TERM:
			sm_io_fprintf(smioout, "got=TERM\n");
			break;
		  case SM_SIG_USR1:
			sm_io_fprintf(smioout, "got=USR1\n");
			break;
		  case SM_SIG_USR2:
			sm_io_fprintf(smioout, "got=USR2\n");
			break;
		  default:
			sm_io_fprintf(smioout, "got=UNKNOWN [%d]\n", (int) sig);
			SM_TEST(false);
			goto error;
		}
		sm_io_flush(smioout);
	} while (sig != SM_SIG_TERM);

	return ret;

  error:
	return ret;
}

int
main(int argc, char *argv[])
{
	sm_ret_T ret;
	int c;
	char *prg;

	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test stthreadssignal");

	c = st_init();
	SM_TEST(c >= 0);
	if (c >= 0)
		ret = t_stthreadssignal();

	return sm_test_end();
}
