/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: smarprtcnf.c,v 1.16 2005/04/29 21:37:44 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "smar.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-prt.h"
#include "sm/smarcnf.h"
#include "sm/smarcnfdef.h"

/*
**  SMAR_PRT_CNF -- Print configuration data
**
**	Parameters:
**		mapdef -- map configuration
**		fp -- file for output
**
**	Returns:
**		none.
*/

static int
smar_mapprtcnf(map_decl_P mapdef, sm_file_T *fp)
{
	mapspec_P md_maps;
	uint n, i;

	if (mapdef == NULL)
		return -1;
	for (n = 0; n < mapdef->mapdecl_n; n++)
	{
		md_maps = mapdef->mapdecl_maps + n;
		if (md_maps == NULL)
			continue;
		sm_io_fprintf(fp, "map {\n", n);
		sm_io_fprintf(fp, "  name = %.256s;\n", md_maps->mst_name);
		sm_io_fprintf(fp, "  type = %.256s;\n", md_maps->mst_type);
		switch (md_maps->mst_kind)
		{
		  case MST_HASH:
			sm_io_fprintf(fp, "  file = %.256s;\n",
				md_maps->mst_hash.mst_hash_fn);
			break;
		  case MST_SOCKET:
			sm_io_fprintf(fp, "  name= %.256s;\n",
				md_maps->mst_name);
			if (md_maps->mst_socket.mst_socket_path != NULL)
			{
				sm_io_fprintf(fp, "  path= %.256s; ",
					md_maps->mst_socket.mst_socket_path);
			}
			else
			{
				sm_io_fprintf(fp, "  address= %A; ",
					md_maps->mst_socket.mst_socket_ipv4);
				sm_io_fprintf(fp, "port= %d; ",
					md_maps->mst_socket.mst_socket_port);
			}
			break;
		  case MST_SEQUENCE:
			sm_io_fprintf(fp, "  maps = { ");
			for (i = 0; md_maps->mst_seq.mst_seq_maps[i] != NULL;
			     i++)
			{
				sm_io_fprintf(fp, "%.256s, ",
					md_maps->mst_seq.mst_seq_maps[i]);
			}
			sm_io_fprintf(fp, "} ");
			break;
		  default:
			break;
		}
		sm_io_fprintf(fp, "}\n");
	}
	return 0;
}

/*
**  SMAR_PRT_CNF -- Print configuration data
**
**	Parameters:
**		smar_cnf -- SMAR configuration context
**		fp -- file for output
**		all -- print also "global" config data?
**
**	Returns:
**		none.
*/

void
smar_prt_cnf(smar_cnf_P smar_cnf, sm_file_T *fp, bool all)
{
	SM_REQUIRE(smar_cnf != NULL);

	if (all)
		(void) sm_conf_prt_conf(smar_global_defs, smar_cnf, fp);
	else
		(void) sm_conf_prt_conf(smar_defs, smar_cnf, fp);
	(void) smar_mapprtcnf(&(smar_cnf->smar_cnf_mapdecl), fp);
}
