#!/bin/sh
# $Id: t-mapaddr-0.sh,v 1.9 2005/06/29 22:59:15 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test lookup of addresses
# Uses t-mapaddrr-0, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

BDBIN="bdb3"
BDB="bdb3.db"
OUT=out3
CMP=cmp3
OK=ok3
DIFF=diff3
ERRS=0

# data for map
cat > ${BDBIN} <<EOF
a.b.c		rhsabc
b.c		rhsbc
c		rhsc
Tag:b.c		rhstagbc
some.nice.domain	rhs-some.nice.domain
nice.domain	rhs-nice.domain
domain		rhs-domain
DomainTag:some.nice.domain	rhs-DomainTag:some.nice.domain
DomainTag:nice.domain		rhs-DomainTag:nice.domain
DomainTag:domain		rhs-DomainTag:domain
Tag:user+detail@nice.domain	rhs-Tag:user-detail-nice.domain
Tag:user++@nice.domain	rhs-Tag:user-plus-nice.domain
Tag:user+*@nice.domain	rhs-Tag:user-star-nice.domain
Tag:user@nice.domain	rhs-Tag:user-nice.domain
Tag:nodetail@nice.domain	rhs-Tag:nodetail-nice.domain
user+detail@nice.domain	rhs-user-detail-nice.domain
user++@nice.domain	rhs-user-plus-nice.domain
user+*@nice.domain	rhs-user-star-nice.domain
user@nice.domain	rhs-user-nice.domain
nodetail@nice.domain	rhs-nodetail-nice.domain
OpenBSD+ports@nice.domain		ok+openbsd_ports
Tag:u2+detail@.sub.domain	rhs-Tag:u2-detail-.sub.domain
Tag:u2++@.sub.domain	rhs-Tag:u2-plus-.sub.domain
Tag:u2+*@.sub.domain	rhs-Tag:u2-star-.sub.domain
Tag:u2@.sub.domain	rhs-Tag:u2-.sub.domain
alias+detail	rhs-alias-detail
alias++	rhs-alias-plus
alias+*	rhs-alias-star
alias	rhs-alias
virt+detail@vhost.domain	rhs-virt-detail-vhost.domain
virt++@vhost.domain	rhs-virt-plus-vhost.domain
virt+*@vhost.domain	rhs-virt-star-vhost.domain
virt@vhost.domain	rhs-virt-vhost.domain
vdom+detail@.domain	rhs-vdom-detail-.domain
vdom++@.domain	rhs-vdom-plus-.domain
vdom+*@.domain	rhs-vdom-star-.domain
vdom@.domain	rhs-vdom-.domain
vlocal+detail@	rhs-vlocal-detail-@
vlocal++@	rhs-vlocal-plus-@
vlocal+*@	rhs-vlocal-star-@
vlocal@	rhs-virt-@
EOF

# create map
rm -f ${BDB}
./t-mm -t'	' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

for P in ./t-mapaddrr-0 # ./t-mapaddr-0
do

# test full lookup
${P} >${OUT} 2>&1 <<EOF
tag:user:detail:nice.domain
tag:user:det:nice.domain
tag:user::nice.domain
tag:nodetail:detail:nice.domain
tag:nodetail:det:nice.domain
tag:nodetail::nice.domain
domaintag:user:detail:nice.domain
domaintag:user:det:nice.domain
domaintag:user::nice.domain
domaintag:nodetail:detail:nice.domain
domaintag:nodetail:det:nice.domain
domaintag:nodetail::nice.domain
N:user:detail:nice.domain
N:user:det:nice.domain
N:user::nice.domain
N:nodetail:detail:nice.domain
N:nodetail:det:nice.domain
N:nodetail::nice.domain
N:openbsd:ports:nice.domain
tag:u2:detail:some.sub.domain
tag:u2:det:some.sub.domain
tag:u2::some.sub.domain
tag:u2:N:some.sub.domain
tag:u2:detail:deeper.some.sub.domain
tag:u2:det:deeper.some.sub.domain
tag:u2::deeper.some.sub.domain
tag:u2:N:deeper.some.sub.domain
EOF

cat >${OK} <<EOF
ret=0, rhs='rhs-Tag:user-detail-nice.domain'
ret=0, rhs='rhs-Tag:user-plus-nice.domain'
ret=0, rhs='rhs-Tag:user-star-nice.domain'
ret=8c040108, rhs=''
ret=8c040108, rhs=''
ret=8c040108, rhs=''
ret=0, rhs='rhs-DomainTag:nice.domain'
ret=0, rhs='rhs-DomainTag:nice.domain'
ret=0, rhs='rhs-DomainTag:nice.domain'
ret=0, rhs='rhs-DomainTag:nice.domain'
ret=0, rhs='rhs-DomainTag:nice.domain'
ret=0, rhs='rhs-DomainTag:nice.domain'
ret=0, rhs='rhs-user-detail-nice.domain'
ret=0, rhs='rhs-user-plus-nice.domain'
ret=0, rhs='rhs-user-star-nice.domain'
ret=0, rhs='rhs-nice.domain'
ret=0, rhs='rhs-nice.domain'
ret=0, rhs='rhs-nice.domain'
ret=0, rhs='ok+openbsd_ports'
ret=0, rhs='rhs-Tag:u2-detail-.sub.domain'
ret=0, rhs='rhs-Tag:u2-plus-.sub.domain'
ret=0, rhs='rhs-Tag:u2-star-.sub.domain'
ret=0, rhs='rhs-Tag:u2-.sub.domain'
ret=0, rhs='rhs-Tag:u2-detail-.sub.domain'
ret=0, rhs='rhs-Tag:u2-plus-.sub.domain'
ret=0, rhs='rhs-Tag:u2-star-.sub.domain'
ret=0, rhs='rhs-Tag:u2-.sub.domain'
EOF

grep -v ' tests completed ' ${OUT} > ${CMP}

diff ${CMP} ${OK} > ${DIFF}
if test $? != 0
then
  echo errors:
  cat ${DIFF}
  ERRS=`expr ${ERRS} + 1 `
fi

# test alias lookup
${P} -a >${OUT} 2>&1 <<EOF
N:alias:detail:N
N:alias:det:N
N:alias::N
N:alias:N:N
EOF

cat >${OK} <<EOF
ret=0, rhs='rhs-alias-detail'
ret=0, rhs='rhs-alias-plus'
ret=0, rhs='rhs-alias-star'
ret=0, rhs='rhs-alias'
EOF

grep -v ' tests completed ' ${OUT} > ${CMP}

diff ${CMP} ${OK} > ${DIFF}
if test $? != 0
then
  echo errors:
  cat ${DIFF}
  ERRS=`expr ${ERRS} + 1 `
fi


# test virtuser lookup
${P} -v >${OUT} 2>&1 <<EOF
N:virt:detail:vhost.domain
N:virt:det:vhost.domain
N:virt::vhost.domain
N:virt:N:vhost.domain
N:vdom:detail:vhost.domain
N:vdom:det:vhost.domain
N:vdom::vhost.domain
N:vdom:N:vhost.domain
N:vdom:detail:other.domain
N:vdom:det:other.domain
N:vdom::other.domain
N:vdom:N:other.domain
N:vlocal:detail:vhost.domain
N:vlocal:det:vhost.domain
N:vlocal::vhost.domain
N:vlocal:N:vhost.domain
N:vlocal:detail:other.domain
N:vlocal:det:other.domain
N:vlocal::other.domain
N:vlocal:N:other.domain
N:vlocal:detail:N
N:vlocal:det:N
N:vlocal::N
N:vlocal:N:N
EOF

cat >${OK} <<EOF
ret=0, rhs='rhs-virt-detail-vhost.domain'
ret=0, rhs='rhs-virt-plus-vhost.domain'
ret=0, rhs='rhs-virt-star-vhost.domain'
ret=0, rhs='rhs-virt-vhost.domain'
ret=0, rhs='rhs-vdom-detail-.domain'
ret=0, rhs='rhs-vdom-plus-.domain'
ret=0, rhs='rhs-vdom-star-.domain'
ret=0, rhs='rhs-vdom-.domain'
ret=0, rhs='rhs-vdom-detail-.domain'
ret=0, rhs='rhs-vdom-plus-.domain'
ret=0, rhs='rhs-vdom-star-.domain'
ret=0, rhs='rhs-vdom-.domain'
ret=0, rhs='rhs-vlocal-detail-@'
ret=0, rhs='rhs-vlocal-plus-@'
ret=0, rhs='rhs-vlocal-star-@'
ret=0, rhs='rhs-virt-@'
ret=0, rhs='rhs-vlocal-detail-@'
ret=0, rhs='rhs-vlocal-plus-@'
ret=0, rhs='rhs-vlocal-star-@'
ret=0, rhs='rhs-virt-@'
ret=0, rhs='rhs-vlocal-detail-@'
ret=0, rhs='rhs-vlocal-plus-@'
ret=0, rhs='rhs-vlocal-star-@'
ret=0, rhs='rhs-virt-@'
EOF

grep -v ' tests completed ' ${OUT} > ${CMP}

diff ${CMP} ${OK} > ${DIFF}
if test $? != 0
then
  echo errors:
  cat ${DIFF}
  ERRS=`expr ${ERRS} + 1 `
fi


done

exit ${ERRS}
