#!/bin/sh
# $Id: t-conf-1.sh,v 1.10 2005/09/01 21:13:17 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# read map configuration files and use the maps to perform lookups
# uses: t-confr-0
# ------------------------------------------------------------

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`
ERRS=0
CNF=map1.conf
OUT=map1.out
OK=map1.ok
PRG=./t-confr-0

M1=map1.db
M2=map2.db

# ----------------------------------------
cat > ${CNF} <<EOF
map hash1 { type = hash; file= ${M1}; }
map hash2 { type = hash; file= ${M2}; }
map password { type = passwd; }
map seq1 { type = sequence; maps = { hash1, hash2}; }
map seq2 { type = sequence; maps = { password, hash2}; }
EOF

rm -f ${M1} ${M2}
./t-mm -t' ' -F ${M1} <<EOF
m1l1 m1r1
m1l2 m1r2
EOF
./t-mm -t' ' -F ${M2} <<EOF
m2l1 m2r1
m2l2 m2r2
EOF

# ----------------------------------------
cat > ${OK} <<EOF
result="m1r1"
EOF
if ${PRG} -m hash1 -l m1l1 ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# ----------------------------------------
cat > ${OK} <<EOF
result="m2r2"
EOF
if ${PRG} -m hash2 -l m2l2 ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# ----------------------------------------
cat > ${OK} <<EOF
result="m2r2"
EOF
if ${PRG} -m seq1 -l m2l2 ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# ----------------------------------------
if ${PRG} -m seq2 -l root ${CNF} >${OUT}
then
  if grep '^result=' ${OUT} >/dev/null
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


## # ----------------------------------------
## cat > ${CNF} <<EOF
## map hash1 { type = hash; file= ${M1}; }
## map hash2 { type = hash; file= ${M2}; }
## map password { type = passwd; flags=implicitly_match_detail;}
## map seq1 { type = sequence; maps = { hash1, hash2}; }
## map seq2 { type = sequence; maps = { password, hash2}; }
## EOF
## 
## # ----------------------------------------
## if ${PRG} -m seq2 -l root -D x -F 0x00001810u ${CNF} >${OUT}
## then
##   if grep '^result=' ${OUT} >/dev/null
##   then
##     :
##   else
##     ERRS=`expr ${ERRS} + 1 `
##     test X"${SM_STOPONERROR}" != X && exit ${ERRS}
##   fi
## else
##   ERRS=`expr ${ERRS} + 1 `
##   test X"${SM_STOPONERROR}" != X && exit ${ERRS}
## fi


# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
