/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_se.c,v 1.11 2005/06/21 17:46:06 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "pmilter.h"

#if SM_USE_PMILTER
/*
**  SM_PMSE_NEW -- Allocate a new SMTP server session context
**
**	Parameters:
**		pmg_ctx -- pmilter (library) context
**		pmss_ctx -- task context pmilter/SMTP server
**		ppmse_ctx -- pmilter/SMTP server session context (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmse_new(pmg_ctx_P pmg_ctx, pmss_ctx_P pmss_ctx, pmse_ctx_P *ppmse_ctx)
{
	sm_ret_T ret;
	pmse_ctx_P pmse_ctx;

	SM_IS_PMG_CTX(pmg_ctx);
	SM_IS_PMSS_CTX(pmss_ctx);
	SM_REQUIRE(ppmse_ctx != NULL);
	pmse_ctx = (pmse_ctx_P) sm_zalloc(sizeof(*pmse_ctx));
	if (pmse_ctx == NULL)
		return sm_error_temp(SM_EM_Q_Q2SS, ENOMEM);
	pmse_ctx->pmse_reply = sm_str_new(NULL, 64, 1024);
	if (pmse_ctx->pmse_reply == NULL)
	{
		ret = sm_error_temp(SM_EM_Q_Q2SS, ENOMEM);
		goto error;
	}
	pmse_ctx->pmse_pmg_ctx = pmg_ctx;
	pmse_ctx->pmse_pmss_ctx = pmss_ctx;

	PMSEL_PRE(&(pmss_ctx->pmss_ss_hd), pmse_ctx);
	pmse_ctx->sm_magic = SM_PMSE_CTX_MAGIC;
	*ppmse_ctx = pmse_ctx;
	return SM_SUCCESS;

  error:
	if (pmse_ctx != NULL)
	{
		sm_free_size(pmse_ctx, sizeof(*pmse_ctx));
		/* SM_STR_FREE(pmse_ctx->pmse_reply); not yet necessary */
	}
	return ret;
}

/*
**  SM_PMSE_FREE -- Free a pmilter/SMTP server session context
**
**	Parameters:
**		pmss_ctx -- task context pmilter/SMTP server
**		pmse_ctx -- pmilter/SMTP server session context
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmse_free(pmss_ctx_P pmss_ctx, pmse_ctx_P pmse_ctx)
{
	uint i, j;

	/* XXX this routine assumes nobody accesses pmse_ctx! */
	if (pmse_ctx == NULL)
		return SM_SUCCESS;
	SM_IS_PMSS_CTX(pmss_ctx);

	SM_STR_FREE(pmse_ctx->pmse_arg1);
	SM_STR_FREE(pmse_ctx->pmse_arg2);
	SM_STR_FREE(pmse_ctx->pmse_reply);
	for (i = 0; i < PM_SMST_MAX; i++)
		for (j = 0; j < PM_MAX_MACROS; j++)
			SM_STR_FREE(pmse_ctx->pmse_mac_values[i][j]);

	PMSEL_REMOVE(&(pmss_ctx->pmss_ss_hd), pmse_ctx);
	pmse_ctx->sm_magic = SM_MAGIC_NULL;
	sm_free_size(pmse_ctx, sizeof(*pmse_ctx));
	return SM_SUCCESS;
}

/*
**  SM_PMSE_FIND -- Find a SMTP server session context based on the session id
**
**	Parameters:
**		pmss_ctx -- PMILTER - SMTP server context
**		se_id -- SMTP session id
**		ppmse_ctx -- pmilter/SMTP server session context (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmse_find(pmss_ctx_P pmss_ctx, smtp_id_P se_id, pmse_ctx_P *ppmse_ctx)
{
	pmse_ctx_P pmse_ctx;

	SM_IS_PMSS_CTX(pmss_ctx);
	SM_REQUIRE(ppmse_ctx != NULL);
	SM_REQUIRE(se_id != NULL);
	SM_REQUIRE(*se_id != '\0');

	if (PMSEL_EMPTY(&(pmss_ctx->pmss_ss_hd)))
		return sm_error_perm(SM_EM_PMILTER, SM_E_NOTFOUND);
	for (pmse_ctx = PMSEL_FIRST(&(pmss_ctx->pmss_ss_hd));
	     pmse_ctx != PMSEL_END(&(pmss_ctx->pmss_ss_hd));
	     pmse_ctx = PMSEL_NEXT(pmse_ctx))
	{
		if (SESSTA_EQ(se_id, pmse_ctx->pmse_se_id))
		{
			*ppmse_ctx = pmse_ctx;
			return SM_SUCCESS;
		}
	}
	return sm_error_perm(SM_EM_PMILTER, SM_E_NOTFOUND);
}
#endif /* SM_USE_PMILTER */
