/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-parsesockstr.c,v 1.1 2005/08/25 20:07:00 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/socket.h"
#include "sm/test.h"
#include "sm/io.h"
#include "sm/hostname.h"

static int Verbosity = 0;

static void
test(const char *str)
{
	sm_ret_T ret;
	sockspec_T sockspec;

	if (str != NULL)
	{
		ret = parsesockstr(str, &sockspec);
		return;
	}
	ret = parsesockstr(NULL, &sockspec);
	SM_TEST(sm_is_err(ret));
	ret = parsesockstr("", &sockspec);
	SM_TEST(sm_is_err(ret));

	ret = parsesockstr("a", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_UNIX);
	SM_TEST(strcmp(sockspec.sock_unix.unixsckspc_path, "a") == 0);

	ret = parsesockstr("inet:25", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_INET);
	SM_TEST(sockspec.sock_inet.inetsckspc_port == htons(25));
	SM_TEST(sockspec.sock_inet.inetsckspc_addr == INADDR_ANY);

	ret = parsesockstr("inet:2525", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_INET);
	SM_TEST(sockspec.sock_inet.inetsckspc_port == htons(2525));
	SM_TEST(sockspec.sock_inet.inetsckspc_addr == INADDR_ANY);

	ret = parsesockstr("inet:62525", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_INET);
	SM_TEST(sockspec.sock_inet.inetsckspc_port == htons(62525));
	SM_TEST(sockspec.sock_inet.inetsckspc_addr == INADDR_ANY);

	ret = parsesockstr("inet:597@[127.0.0.1]", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_INET);
	SM_TEST(sockspec.sock_inet.inetsckspc_port == htons(597));
	SM_TEST(sockspec.sock_inet.inetsckspc_addr == inet_addr("127.0.0.1"));

	ret = parsesockstr("inet:597@localhost", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_INET);
	SM_TEST(sockspec.sock_inet.inetsckspc_port == htons(597));
	SM_TEST(sockspec.sock_inet.inetsckspc_addr == inet_addr("127.0.0.1"));

	ret = parsesockstr("inet:162525", &sockspec);
	SM_TEST(sm_is_err(ret));

	ret = parsesockstr("inet:597@[]", &sockspec);
	SM_TEST(sm_is_err(ret));

	ret = parsesockstr("unix:", &sockspec);
	SM_TEST(sm_is_err(ret));

	ret = parsesockstr("inet6:", &sockspec);
	SM_TEST(sm_is_err(ret));

	ret = parsesockstr("bogus:", &sockspec);
	SM_TEST(sm_is_err(ret));

	ret = parsesockstr("unix:a", &sockspec);
	SM_TEST(sm_is_success(ret));
	SM_TEST(sockspec.sckspc_type == SOCK_TYPE_UNIX);
	SM_TEST(strcmp(sockspec.sock_unix.unixsckspc_path, "a") == 0);

	return;
}

int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbosity;
			break;
		}
	}
	sm_test_begin(argc, argv, "test parsesockstr");
	argc -= optind;
	argv += optind;
	if (argc > 0)
	{
		for (c = 0; c < argc; c++)
			test(argv[c]);
	}
	else
		test(NULL);
	return sm_test_end();
}
