/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: parsectlvl.c,v 1.1 2005/06/13 19:01:10 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/limits.h"
#include "sm/util.h"

/*
**  SM_PARSE_CT_LVL -- parse category and level
**	first[-last][.level]
**	level defaults to 1.
**
**	Parameters:
**		ptr -- (pointer to) argument to parse
**		pfirst -- (pointer to) first category (output)
**		plast -- (pointer to) last category (output)
**		plevel -- (pointer to) level (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_parse_ct_lvl(char **ptr, ulong *pfirst, ulong *plast, ulong *plevel)
{
	ulong first, last, level;
	char *endptr, *s;

	SM_REQUIRE(ptr != NULL);
	SM_REQUIRE(*ptr != NULL);
	SM_REQUIRE(pfirst != NULL);
	SM_REQUIRE(plevel != NULL);

	/* find first flag to set */
	s = *ptr;
	first = strtoul(s, &endptr, 10);
	if (endptr == s || first == ULONG_MAX)
		return sm_err_perm(EINVAL);

	s = endptr;
	if (*s == '-')
	{
		++s;
		last = strtoul(s, &endptr, 10);
		if (endptr == s || last == ULONG_MAX || last < first)
			return sm_err_perm(EINVAL);
		s = endptr;
	}
	else
		last = first;

	/* find the level to set it to */
	if (*s == '.')
	{
		++s;
		level = strtoul(s, &endptr, 10);
		if (endptr == s || level == ULONG_MAX)
			return sm_err_perm(EINVAL);
	}
	else
		level = 1;

	*pfirst = first;
	if (plast != NULL)
		*plast = last;
	*plevel = level;
	*ptr = endptr;
	return SM_SUCCESS;
}
