#!/bin/sh
# $Id: t-dumpdef-0.sh,v 1.88 2005/10/25 23:33:41 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# show ("dump") configuration
# uses dumpdef
# ----------------------------------------

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=smx.conf
OUT=smx.out
OK=smx.ok

PRG=./dumpdef

cat > ${CNF} <<EOF
EOF

${PRG} -VVV |grep 'SM_USE_SASL' >${OUT} 2>&1
if test -s ${OUT}
then
AUTHOPTS='auth {
# Flags for Cyrus SASL (AUTH)
# flags is not set by default
# List of SASL mechanisms for which relaying is allowed if a client
# successfully authenticated using one of those
trusted_mechanisms="PLAIN LOGIN DIGEST-MD5 CRAM-MD5";
}'
else
AUTHOPTS=""
fi

${PRG} -VVV |grep 'SM_USE_TLS' >${OUT} 2>&1
if test -s ${OUT}
then
TLSSRVOPTS='tls {
# File with certificate in PEM format
cert_file="smcert.pem";
# File with private key for certificate in PEM format
key_file="smkey.pem";
# File with DSA certificate in PEM format
# DSA_cert_file is not set by default
# File with private key for DSA certificate in PEM format
# DSA_key_file is not set by default
# File with CA certificate in PEM format
CAcert_file="CAcert.pem";
# Directory with (symbolic links for) CA certificates in PEM format
CAcert_directory="certs";
}'
else
TLSSRVOPTS=""
fi

${PRG} -VVV |grep 'SM_USE_TLS' >${OUT} 2>&1
if test -s ${OUT}
then
TLSOPTS='tls {
# File with certificate in PEM format
cert_file="smcert.pem";
# File with private key for certificate in PEM format
key_file="smkey.pem";
# File with DSA certificate in PEM format
# DSA_cert_file is not set by default
# File with private key for DSA certificate in PEM format
# DSA_key_file is not set by default
# File with CA certificate in PEM format
CAcert_file="CAcert.pem";
# Directory with (symbolic links for) CA certificates in PEM format
CAcert_directory="certs";
}'
else
TLSOPTS=""
fi

${PRG} -VVV |grep 'SM_USE_PMILTER' >${OUT} 2>&1
if test -s ${OUT}
then
PMILTEROPTS='# policy milter
policy_milter {
# maximum amount of time to wait for a reply from a policy milter
timeout=20;
}'
else
PMILTEROPTS=""
fi

${PRG} -VVV |grep 'QMGR_TEST' >${OUT} 2>&1
if test -s ${OUT}
then
QMGRTESTOPTS='
tests=0;'
else
QMGRTESTOPTS=""
fi

sed -e 's/^  *//' -e '/^$/d' > ${OK} <<EOF
SMTPC_socket="qmsmtpc/qmsmtpc";
SMTPS_socket="qmsmtps/qmsmtps";
SMAR_socket="qmsmar/qmsmar";
CDB_base_directory="";
smar {
# List of nameservers (IPv4 addresses)
# nameserver is not set by default
# DNS_Flags is not set by default
DNS_timeout=2;
log_level=99999;
# minimum number of threads [experts only]
min_threads=2;
# maximum number of threads [experts only]
max_threads=16;
# maximum number of file descriptors [experts only]
max_fds=10;
# DNS based blacklists
# dnsbl is not set by default
# Greylisting options
greylisting {
# how long before greylisted can be "confirmed"
grey_wait=60;
# timeout for greylisted entries (didn't "confirm" within that time)
grey_expire=24 *60*60;
# expire whitelisted entries after this time if necessary
white_expire=33 *60*60*24;
# force whitelisted entries to reconfirm after this time
white_timeout=40 *60*60*24;
# name of main database (including .db extension)
main_DB_name="grey_grey_m.db";
# name of secondary database (including .db extension)
secondary_DB_name="grey_grey_s.db";
# try to expire entries when this limit is reached
expire_limit=10000;
# apply netmask to IPv4 address
netmask=0xFFFFFFFF;
}
# Map Declarations
# map is not set by default
# delimiter for address extensions in local part
address_delimiter=+;
# aliases definition
aliases {
# filename of aliases map (including extension)
file="aliases.db";
}
# mailertable definition
mailertable {
# filename of mailertable file
file="mt";
}
# access map definition
access_map {
# filename of access map (including extension)
file="access.db";
}
# minimum number of processes
min_processes=1;
# maximum number of processes
max_processes=1;
# run process as user
user="";
# run process as group
group="";
# list of services to restart in case of failure
# restart_dependencies is not set by default
# pass id to process in argument list with this option
# pass_id is not set by default
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=0;
# path to program
path="";
# arguments for program
arguments="";
# working directory (chdir(2))
# working_directory is not set by default
# how to handle program
start_action="wait";
}
smtpc {
# port to connect to on server
remote_port=25;
LMTP_socket="lmtpsock";
# number of processes to start [currently not implemented]
processes=1;
# maximum number of threads
max_threads=0;
# maximum number of waiting threads
max_wait_threads=8;
# minimum number of waiting threads
min_wait_threads=2;
flags=0;
log_level=99999;
debug_level=0;
# timeout for SMTP I/O operations
io_timeout=120;
# maximum amount of time to wait for a server to become available
wait_for_server=1;
# unique id
id=1;
# connect only to this IPv4 address [testing]
connect_only_to=0;
${TLSOPTS}
# minimum number of processes
min_processes=1;
# maximum number of processes
max_processes=1;
# run process as user
user="";
# run process as group
group="";
# list of services to restart in case of failure
# restart_dependencies is not set by default
# pass id to process in argument list with this option
# pass_id is not set by default
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=0;
# path to program
path="";
# arguments for program
arguments="";
# working directory (chdir(2))
# working_directory is not set by default
# how to handle program
start_action="wait";
}
smtps {
# path of Unix domain socket to exchange file descriptor [use with MCP]
# pass_fd_socket is not set by default
# address for daemon to listen on [do not use with MCP]
# daemon_address is not set by default
# length of listen(2) queue [do not use with MCP]
listen_queue=256;
# log level
log_level=99999;
# allow relaying from IPv4 addresses that match this regular expression
relay_from="127.0.0.1";
# allow relaying to addresses that match this regular expression
relay_to="(^<postmaster>|@localhost>)$";
# group id (numeric) to use for CDB files
cdb_gid=0;
# (unique) id for server (if multiple SMTP servers are configured)
id=0;
# maximum number of transactions per session
max_transactions=65535;
# maximum number of recipients per session
max_recipients_per_session=65535;
# maximum number of recipients per transaction
max_recipients_per_transaction=65535;
# maximum number of hops (Received: headers)
max_hops=21;
# maximum message size (KB)
max_message_size=64 *1024;
# maximum number of bad SMTP commands per session
max_bad_commands_per_session=3;
# maximum number of SMTP commands with invalid addresses per session
max_invalid_addresses_per_session=200;
# maximum number of nop SMTP commands between transactions
max_nop_commands_between_transactions=5;
# maximum number of bad SMTP commands per transaction
max_bad_commands_per_transaction=3;
# maximum number of nop SMTP commands in a single transaction
max_nop_commands_in_transaction=5;
# maximum number of SMTP commands with invalid addresses per transaction
max_invalid_addresses_per_transaction=100;
# timeout for SMTP I/O operations
io_timeout=300;
# maximum number of threads
max_threads=0;
# maximum number of waiting threads
max_wait_threads=8;
# minimum number of waiting threads
min_wait_threads=2;
# number of processes to start
processes=1;
# maximum amount of time to wait for a server to become available
wait_for_server=1;
# maximum amount of time to wait for a reply from smar
wait_for_smar=20;
# debug level
debug_level=0;
${TLSSRVOPTS}
${AUTHOPTS}
${PMILTEROPTS}
# minimum number of processes
min_processes=1;
# maximum number of processes
max_processes=1;
# run process as user
user="";
# run process as group
group="";
# list of services to restart in case of failure
# restart_dependencies is not set by default
# pass id to process in argument list with this option
# pass_id is not set by default
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=0;
# path to program
path="";
# arguments for program
arguments="";
# working directory (chdir(2))
# working_directory is not set by default
# how to handle program
start_action="wait";
}
qmgr {
# maximum number of entries in AQ (active queue)
AQ_max_entries=4096;
# maximum number of entries in OCC (outgoing connection cache)
OCC_max_entries=2111;
IBDB {
# maximum size of each IBDB file
size=65536;
# maximum number of open transactions in IBDB before a commit is performed
max_open_TAs=32;
# maximum time between commits to IBDB (micro seconds)
max_commit_delay=1000;
}
IQDB {
# maximum number of entries in IQDB cache
max_cache_entries=1023;
# size of hash table for IQDB
hash_table_entries=2111;
}
# minimum amount of free disk space (KB)
min_disk_space=16 *1024;
# amount of free disk space at which normal operation continues (KB)
ok_disk_space=32 *1024;
smtpc {
# initial number of outgoing connections to a single host
initial_connections=10;
# maximum number of outgoing connections to a single host
max_connections=100;
# maximum number of recipients per transaction (smtp)
smtp_max_rcpts_per_transaction=1000;
# maximum number of recipients per transaction (lmtp)
lmtp_max_rcpts_per_transaction=1000;
}
smtps {
# maximum number of open incoming connection from a single host
max_connections=100;
# maximum incoming connection rate from a single host
max_connection_rate=100;
# size of connection control hash table [experts only]
connection_control_hash_table_size=256;
}
# flags is not set by default
# minimum time for retrying a delivery
retry_min_delay=256;
# maximum time for retrying a delivery
retry_max_delay=3600;
# maximum time in queue
queue_return_timeout=345600;
# send delay warning after this time in queue
queue_delay_timeout=14400;
# timeout in address resolver
SMAR_timeout=120;
# timeout for a single delivery attempt
delivery_timeout=600;
# maximum time waiting to be scheduled
scheduler_timeout=900;
# maximum amount of time to wait for a server to become available
wait_for_server=1;
# maximum amount of time to wait for a client to become available
wait_for_client=1;
log_level=99999;
debug_level=0;${QMGRTESTOPTS}
DSN_handling {
# maximum number of error messages (failed recipients) in a bounce (DSN)
max_errors_per_DSN=100;
# maximum time to wait for merging multiple DSNs into one
merge_delay_max=1;
}
DEFEDB {
# Home directory for DEFEDB
# base_directory is not set by default
# Log directory for DEFEDB
# log_directory is not set by default
# DB page size
# page_size is not set by default
# DB cache size
cache_size=4 *1024*1024;
# If non-zero, a checkpoint will be done if more than the amount of KBytes
# of log data have been written since the last checkpoint
# KBytes_written_for_checkpointing is not set by default
# Minimum delay between two checkpoints
delay_between_2_checkpoints=600;
}
# name of control socket
# control_socket is not set by default
# name of configuration map (including extension)
conf="qmgr_conf.db";
# minimum number of threads [experts only]
min_threads=2;
# maximum number of threads [experts only]
max_threads=6;
# maximum number of file descriptors [experts only]
max_fds=10;
# minimum number of processes
min_processes=1;
# maximum number of processes
max_processes=1;
# run process as user
user="";
# run process as group
group="";
# list of services to restart in case of failure
# restart_dependencies is not set by default
# pass id to process in argument list with this option
# pass_id is not set by default
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=0;
# path to program
path="";
# arguments for program
arguments="";
# working directory (chdir(2))
# working_directory is not set by default
# how to handle program
start_action="wait";
}
EOF

if ${PRG} ${CNF} | sed -e 's/^  *//' -e '/^$/d' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
