/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rdstr.h,v 1.3 2005/08/08 17:16:22 ca Exp $
 */

#ifndef SM_RDSTR_H
#define SM_RDSTR_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/assert.h"
#include "sm/error.h"

typedef struct sm_rdstr_S sm_rdstr_T, *sm_rdstr_P;

/*
**  sm_rdstr_T -- Stores buf data and length information.
**
**	Members:
**		sm_rdstr_base -- uchar * to data (doesn't need to end with '\0')
**		sm_rdstr_len -- Total number of characters in buf
**
**	Note: this is a "read only" version of sm_str_P and sm_cstr_P.
**		The first few elements in those three types must be identical
**		to allow for the macros to access the data correctly.
**		This type can be used in functions that need only read access
**		to a "string", such that sm_str_P and sm_cstr_P can be passed
**		to them.
*/

struct sm_rdstr_S
{
	sm_magic_T	 sm_magic;
	uchar		*sm_rdstr_base;
	uint		 sm_rdstr_len;
};

#define SM_RDSTR_GETLEN(str)	((str)->sm_rdstr_len)
#define SM_RDSTR_RD_ELEM(str, i) (SM_ASSERT((i) < ((str)->sm_rdstr_len)), ((str)->sm_rdstr_base[i]))
#define SM_RDSTR_DATA(str)	((str)->sm_rdstr_base)

#define SM_IS_RDSTR(rdstr)	\
		SM_REQUIRE((rdstr) != NULL &&	\
		(((rdstr)->sm_magic == SM_STR_MAGIC) ||	\
		 (rdstr)->sm_magic == SM_CSTR_MAGIC))


#endif /* SM_RDSTR_H */
