#!/bin/sh
# $Id: t-smtp.sh,v 1.15 2005/09/06 23:23:58 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test multiple recipients, transactions, sender threads
# run smtp.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""

# clean up before running tests
cd ../qmgr || exit 1
rm -f ${MTMAP} ${QMGRCONFMAP} ${ACCMAP} ${ALIMAP}

# number of recipients
for n in 1 2 3
do
  # transactions
  for T in 1 2 4
  do
    # threads to use
    for t in 1 2 4
    do
       #${SHELL} ${SD}/smtp.sh ${I} -n ${n} -T ${T} -t ${t} || ERRS=`expr ${ERRS} + 1 `
       ${SHELL} ${SD}/smtp.sh $@ ${I} -n ${n} -T ${T} -t ${t} || exit 1
       # test -s *.core && exit 2
       I="-D"
    done
  done
done
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
