#!/bin/sh
# $Id: t-mts-ocr-2.sh,v 1.15 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test outgoing connection restrictions.
# two tests: concurrency limit 1/2, check number of busy threads in sink;
# all mails should be delivered within a "short" timeframe, i.e.,
# the scheduler should be activated whenever a session close to keep
# a "steady" delivery rate (make maximum use of allowed limits).
# uses mcpmts.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
# currently set in mta-setup.sh
CLTL=sink.log

I=""
OUT="t-mts-ocr-2.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

killit()
{
rm -f ${QMGRCONFMAP} ${MTMAP}
exit 1
}

rm -f ${QMGRCONFMAP} ${MTMAP} ${OUT}

# create restrictions: maximum concurrency: 1
${CAT} > ${QMGRCONF} <<EOF
oci:10.1.1.2	1
ocm:10.1.1.2	1
EOF
# create map
${MM} -t'	' -F ${QMGRCONFMAP} < ${QMGRCONF}
trap killit 2

# ----------------------------------------
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 14; pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS} -d 3";
}
smtpc { log_level = 14; remote_port = ${SNKPORT}; wait_for_server=4;
	connect_only_to = 127.0.0.1;
	io_timeout=60s;
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF} -d 3";
}
qmgr { log_level = 14; wait_for_server=4; wait_for_client=4; 
	retry_min_delay = 300;
	start_action = wait; user = ${USER};
	# restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF} -d 3";
}
smar { log_level = 14;
	start_action = wait; user = ${USER};
	# restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

${CAT} > ${MT} <<EOF
dom1.tld	[10.1.1.1]
dom2.tld	[10.1.1.2]
dom3.tld	[10.1.1.3]
dom4.tld	[10.1.1.4]
dom5.tld	[10.1.1.5]
dom6.tld	[10.1.1.6]
dom7.tld	[10.1.1.7]
dom8.tld	[10.1.1.8]
dom9.tld	[10.1.1.9]
EOF

# ----------------------------------------
# 
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
for i in smar smtps smtpc qmgr
do
  cp /dev/null ${i}.log
done

if ${SHELL} ${SD}/mcpmts.sh -Y '-w1' -c '-s 10 -D dom2.tld -F dom1.tld' -N -s 20 -A 10 -E 10
then
  if ${GREP} 'Max busy threads .* 1$' ${CLTL} >/dev/null
  then
    ${VERBOSE} && echo "test ${TEST} succeeded"
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
rm -f ${QMGRCONFMAP} ${OUT}
# create restrictions: maximum concurrency: 2
${CAT} > ${QMGRCONF} <<EOF
oci:10.1.1.2	2
ocm:10.1.1.2	2
EOF
# create map
${MM} -t'	' -F ${QMGRCONFMAP} < ${QMGRCONF}
trap killit 2

# ----------------------------------------
# 
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

for i in smar smtps smtpc qmgr
do
  cp /dev/null ${i}.log
done

if ${SHELL} ${SD}/mcpmts.sh -Y '-w1' -c '-s 10 -D dom2.tld -F dom1.tld' -N -s 20 -A 10 -E 10
then
  if ${GREP} 'Max busy threads .* 2$' ${CLTL} >/dev/null
  then
    ${VERBOSE} && echo "test ${TEST} succeeded"
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi



# -----------------
rm -f ${QMGRCONFMAP} ${MTMAP} ${OUT}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
