#!/bin/sh
# $Id: t-max-rcpts-0.sh,v 1.7 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test max recipient restrictions in server
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
max_recipients_per_session=3;
max_recipients_per_transaction=2;
}

EOF


# ----------------------------------------
# reject 3rd recipient in TA
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -Z 'smtpc2' -c '-E' -E 2 -A 1 -X 1 $@ -S"s${TEST}@b.c" -n 3 -R"r1-${TEST}@y.z -Rr2-${TEST}@y.z -Rr3-${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'RCPT=error, text=452 4.5.3 Too many recipients' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# accept 2 recipients in TA
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -Z 'smtpc2' -c '-E' -E 2 -A 1 -X 1 $@ -S"s${TEST}@b.c" -n 2 -R"r1-${TEST}@y.z -Rr2-${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'RCPT=error, text=452 4.5.3 Too many recipients' ${CLTL} >/dev/null
then
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# accept 2 recipients in 1st TA, reject 4th recipient overall
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -Z 'smtpc2' -c '-E' -E 3 -A 2 -X 2 $@ -S"s${TEST}@b.c" -T 2 -n 2 -R"r1-${TEST}@y.z -Rr2-${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'RCPT=error, text=452 4.5.3 Too many recipients' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
