/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: timing.h,v 1.3 2005/06/16 00:39:02 ca Exp $
 */

#ifndef CHECK_TIMING_H
#define CHECK_TIMING_H 1

#include <sys/time.h>
#define toseconds(x, y)	((x).tv_sec - (y).tv_sec)

static bool Timing = false;
struct timeval t1, t2;

#define GT(ti) do {	\
	if (gettimeofday((ti), NULL) < 0)	\
		perror("gettimeofday");	\
	} while (0)
#define START() GT(&t1)
#define END() GT(&t2)
#define DONE() do { if (Timing) \
	printf("function time: %ld seconds\n", toseconds(t2, t1));	\
	} while (0)

#endif /* CHECK_TIMING_H */
