/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-strcmp.c,v 1.5 2004/12/29 23:47:29 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s1, sn;
	size_t len;
	char *src1 = "1234567890";
	char *src2 = "9876543210";
	char *src3 = "123456789";
	char *src4 = "12345678901";

	len = strlen(src1) + strlen(src2);
	s1 = sm_str_scpy(a, src1, len);
	SM_TEST(s1 != NULL);
	SM_TEST(sm_str_getlen(s1) == strlen(src1));
	sn = sm_str_scpy(a, src2, len);
	SM_TEST(sn != NULL);
	SM_TEST(sm_str_getlen(s1) == strlen(src2));

	SM_TEST(!sm_str_eq(s1, sn));
	SM_TEST(sm_str_eq(s1, s1));

	SM_TEST(sm_str_cmp(s1, sn) < 0);
	SM_TEST(sm_str_cmp(s1, s1) == 0);
	SM_TEST(sm_str_cmp(sn, s1) > 0);

	sm_str_free(sn);
	sn = sm_str_scpy(a, src3, len);
	SM_TEST(sn != NULL);
	SM_TEST(sm_str_getlen(s1) == strlen(src2));
	SM_TEST(!sm_str_eq(s1, sn));
	SM_TEST(sm_str_cmp(s1, sn) > 0);
	SM_TEST(sm_str_cmp(sn, s1) < 0);

	sm_str_free(sn);
	sn = sm_str_scpy(a, src4, len);
	SM_TEST(sn != NULL);
	SM_TEST(!sm_str_eq(s1, sn));
	SM_TEST(sm_str_cmp(s1, sn) < 0);
	SM_TEST(sm_str_cmp(sn, s1) > 0);
	SM_TEST(sm_str_shorten(sn, -1) == SM_SUCCESS);
	SM_TEST(sm_str_eq(s1, sn));
	SM_TEST(sm_str_cmp(s1, sn) == 0);
	SM_TEST(sm_str_cmp(sn, s1) == 0);
	SM_TEST(sm_str_shorten(sn, -1) == SM_SUCCESS);
	SM_TEST(!sm_str_eq(s1, sn));
	SM_TEST(sm_str_cmp(s1, sn) > 0);
	SM_TEST(sm_str_cmp(sn, s1) < 0);

	SM_TEST(sm_str_shorten(s1, -1) == SM_SUCCESS);
	sm_str_free(sn);
	sn = sm_str_scpy(a, src3, len);
	SM_TEST(sn != NULL);
	SM_TEST(sm_str_getlen(s1) == strlen(src3));
	SM_TEST(sm_str_eq(s1, sn));
	SM_TEST(sm_str_cmp(s1, sn) == 0);
	SM_TEST(sm_str_cmp(sn, s1) == 0);

	SM_TEST(sm_str_shorten(s1, -sm_str_getlen(s1)) == SM_SUCCESS);
	SM_TEST(sm_str_shorten(s1, 0) == SM_SUCCESS);
	SM_TEST(sm_str_shorten(s1, 1) != SM_SUCCESS);
	SM_TEST(sm_str_shorten(s1, -1) != SM_SUCCESS);

	sm_str_free(s1);
	sm_str_free(sn);

}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test bufc");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
