/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-diskspace.c,v 1.4 2004/12/29 23:47:29 ca Exp $")

#include "sm/error.h"
#include "sm/statfs.h"
#include "sm/io.h"
#include "sm/test.h"

static int Verbose;

int
main(int argc, char *argv[])
{
	sm_ret_T ret;
	int c, r;
	ulong ds, blocksize;
	char *dir, *prg;

	opterr = 0;
	Verbose = 0;
	dir = ".";
	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test freediskspace");
	if (argc > 0)
	{
		for (r = 0; r < argc; r++)
		{
			ret = freediskspace(argv[r], &blocksize, &ds);
			SM_TEST(ret == SM_SUCCESS);
			SM_TEST(ds > 0);
			SM_TEST(blocksize > 0);
			if (Verbose)
				sm_io_fprintf(smioout,
					"dir='%s', diskspace=%ld, blocksize=%ld\n",
					argv[r], ds, blocksize);
		}
	}
	else
	{
		ret = freediskspace(dir, &blocksize, &ds);
		SM_TEST(ret == SM_SUCCESS);
		SM_TEST(ds > 0);
		SM_TEST(blocksize > 0);
		if (Verbose)
			sm_io_fprintf(smioout,
				"diskspace=%ld, blocksize=%ld\n",
				ds, blocksize);
	}
	if (Verbose)
		sm_io_flush(smioout);
	return sm_test_end();
}
