#!/usr/bin/awk -f
#
# $Id: top2dot.awk,v 1.1 2002/10/25 02:19:00 jabley Exp $
#
# take a top-format file from mktop and groom it into a
# dot-format file for graphviz, including edges with
# one end in a nominated country/region/site.
#

BEGIN {
  FS=":";
  print "graph group {";
  print "edge [color=red,fontsize=10,fontcolor=red];"
  print "node [fontsize=10,height=0.1,width=0.1,shape=ellipse];"

  COLOCATED = 1;
  COREGIONAL = 2;
  CONATIONAL = 3;
  DISTANT = 4;

  weight[COLOCATED] = 4000; minlen[COLOCATED] = 1;
  weight[COREGIONAL] = 2000; minlen[COREGIONAL] = 1000;
  weight[CONATIONAL] = 1000; minlen[CONATIONAL] = 2000;
  weight[DISTANT] = 1; minlen[DISTANT] = 4000;

  COLOUR_MAP = "black";
  COLOUR_NEIGHBOUR = "gray";
}

($1 == "node") {
  country[$2] = $3;
  region[$2] = $4;
  site[$2] = $5;
  name[$2] = $6;

# Uncomment the following if you want to be able to specify
# constraints for selecting nodes and edges that are included
# in the DOT file. You could specify these by invoking this
# script with "-v map_country=US", for example, to include
# elements in the US.
#
#  if (map_country == $3 || map_region == $4 || map_site == $5)
#    on_map[$2] = 1;
#  else
#    on_map[$2] = 0;
#
# The following line includes everything, so comment it out if
# you're doing something more fancy.

  on_map[$2] = 1;

  next;
}

function show_node(n) {
  if (node_shown[n] != 1) {
    colour = (on_map[n] ? COLOUR_MAP : COLOUR_NEIGHBOUR);
    printf "n%s [label=\"%s\",color=%s,fontcolor=%s];\n", \
      n, name[n], colour, colour;
    node_shown[n] = 1;
  }
}


function show_edge(n, m, sp) {
  if (edge_shown[n "-" m] != 1 && edge_shown[m "-" n] != 1) {

    if (site[n] == site[m])
      edget = COLOCATED;
    else
      if (region[n] == region[m])
        edget = COREGIONAL;
      else
        if (country[n] == country[m])
          edget = CONATIONAL;
        else
          edget = DISTANT;

    printf "n%s -- n%s [weight=%s,minlen=%s,label=%s];\n", \
      n, m, weight[edget], minlen[edget], sp;
    edge_shown[n "-" m] = 1;
    edge_shown[m "-" n] = 1;
  }
}

($1 == "edge") {
  n0 = $5;
  n1 = $8;
  if (on_map[n0] || on_map[n1]) {
    show_node(n0);
    show_node(n1);
    show_edge(n0, n1, $9);
  }
}

END {
  print "\};";
}

