#!/bin/sh
#
# $Id: daily.sh,v 1.2 2002/10/29 19:41:11 jabley Exp $
#
# Mail the unused/undefined filter report that we last generated.

home=$(dirname $0)

# set this to a distribution list
#mailto="someone@example.com noc@isp.net"

if [ -z "${mailto}" ]; then
  echo "set the mailto variable in $0 before running"
  exit 1
fi

for n in unused undefined; do
  cat ${home}/doc/${n}.1.txt ${home}/doc/dummy.diffs \
    ${home}/doc/${n}.2.txt ${home}/report.${n}.new \
    ${home}/doc/${n}.3.txt ${home}/ident ${home}/doc/${n}.4.txt | \
      mail -s "[filter-audit] ${n} filter audit report" ${mailto}
  mv ${home}/report.${n}.new ${home}/report.${n}.old
done

