#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test-epp-parser.pl,v 1.6 2003/02/15 00:28:38 explorer Exp $

use lib '@prefix@';

use strict;
use warnings;

use Data::Dumper;
use ISC::SRS::EPPParser;


# the following EPP requests are lifted straight out of the provreg
# drafts.

my $tests = {
    "hello" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
             epp-1.0.xsd">
             <hello/>
         </epp>',

    "login" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <login>
               <clID>   ClientX</clID>
               <pw>foo-BAR2</pw>
               <newPW>bar-FOO2</newPW>
               <options>
                 <version>1.0</version>
                 <lang>en</lang>
               </options>
               <svcs>
                 <objURI>urn:ietf:params:xml:ns:obj1</objURI>
                 <objURI>urn:ietf:params:xml:ns:obj2</objURI>
                 <objURI>urn:ietf:params:xml:ns:obj3</objURI>
                 <svcExtension>
                   <extURI>http://custom/obj1ext-1.0</extURI>
                 </svcExtension>
               </svcs>
             </login>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "logout" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <logout/>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-check" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <check>
               <domain:check
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example1.tld</domain:name>
                 <domain:name>example2.tld</domain:name>
                 <domain:name>example3.tld</domain:name>
               </domain:check>
             </check>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-info-no-auth" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <info>
               <domain:info
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name hosts="all">example.tld</domain:name>
               </domain:info>
             </info>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-info-auth" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <info>
               <domain:info
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name hosts="all">example.tld</domain:name>
                 <domain:authInfo>
                   <domain:pw>2fooBAR</domain:pw>
                 </domain:authInfo>
               </domain:info>
             </info>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-transfer-query" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <transfer op="query">
               <domain:transfer
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example.tld</domain:name>
                 <domain:authInfo>
                   <domain:pw roid="JD1234-REP">2fooBAR</domain:pw>
                 </domain:authInfo>
               </domain:transfer>
             </transfer>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-create" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <create>
               <domain:create
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example.tld</domain:name>
                 <domain:period unit="y">2</domain:period>
                 <domain:ns>ns1.example.tld</domain:ns>
                 <domain:ns>ns1.example2.tld</domain:ns>
                 <domain:registrant>jd1234</domain:registrant>
                 <domain:contact type="admin">sh8013</domain:contact>
                 <domain:contact type="tech">sh8013</domain:contact>
                 <domain:authInfo>
                   <domain:pw>2fooBAR</domain:pw>
                 </domain:authInfo>
               </domain:create>
             </create>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-delete" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <delete>
               <domain:delete
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example.tld</domain:name>
               </domain:delete>
             </delete>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-renew" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <renew>
               <domain:renew
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example.tld</domain:name>
                 <domain:curExpDate>2000-04-03</domain:curExpDate>
                 <domain:period unit="y">5</domain:period>
               </domain:renew>
             </renew>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-transfer-request" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <transfer op="request">
               <domain:transfer
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example.tld</domain:name>
                 <domain:period unit="y">1</domain:period>
                 <domain:authInfo>
                   <domain:pw roid="JD1234-REP">2fooBAR</domain:pw>
                 </domain:authInfo>
               </domain:transfer>
             </transfer>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "domain-update" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <update>
               <domain:update
                xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0
                domain-1.0.xsd">
                 <domain:name>example.tld</domain:name>
                 <domain:add>
                   <domain:ns>ns2.example2.tld</domain:ns>
                   <domain:contact type="tech">mak21</domain:contact>
                   <domain:status s="clientHold"
                    lang="en">Payment overdue.</domain:status>
                 </domain:add>
                 <domain:rem>
                   <domain:ns>ns1.example2.tld</domain:ns>
                   <domain:contact type="tech">sh8013</domain:contact>
                   <domain:status s="clientUpdateProhibited"/>
                 </domain:rem>
                 <domain:chg>
                   <domain:registrant>sh8013</domain:registrant>
                   <domain:authInfo>
                     <domain:pw>2BARfoo</domain:pw>
                   </domain:authInfo>
                 </domain:chg>
               </domain:update>
             </update>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "host-check" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <check>
               <host:check
                xmlns:host="urn:ietf:params:xml:ns:host-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0
                host-1.0.xsd">
                 <host:name>ns1.example.tld</host:name>
                 <host:name>ns2.example.tld</host:name>
                 <host:name>ns3.example.tld</host:name>
               </host:check>
             </check>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "host-info" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <info>
               <host:info
                xmlns:host="urn:ietf:params:xml:ns:host-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0
                host-1.0.xsd">
                 <host:name>ns1.example.tld</host:name>
               </host:info>
             </info>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "host-create" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <create>
               <host:create
                xmlns:host="urn:ietf:params:xml:ns:host-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0
                host-1.0.xsd">
                 <host:name>ns1.example.tld</host:name>
                 <host:addr ip="v4">192.1.2.3</host:addr>
                 <host:addr ip="v4">198.1.2.3</host:addr>
                 <host:addr ip="v6">1080:0:0:0:8:800:200C:417A</host:addr>
               </host:create>
             </create>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "host-delete" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <delete>
               <host:delete
                xmlns:host="urn:ietf:params:xml:ns:host-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0
                host-1.0.xsd">
                 <host:name>ns1.example.tld</host:name>
               </host:delete>
             </delete>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "host-update" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <update>
               <host:update
                xmlns:host="urn:ietf:params:xml:ns:host-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0
                host-1.0.xsd">
                 <host:name>ns1.example.tld</host:name>
                 <host:add>
                   <host:addr ip="v4">192.3.2.1</host:addr>
                   <host:status s="clientUpdateProhibited"/>
                 </host:add>
                 <host:rem>
                   <host:addr ip="v6">1080:0:0:0:8:800:200C:417A</host:addr>
                 </host:rem>
                 <host:chg>
                   <host:name>ns2.example.tld</host:name>
                 </host:chg>
               </host:update>
             </update>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-check" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <check>
               <contact:check
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
                 <contact:id>sah8013</contact:id>
                 <contact:id>8013sah</contact:id>
               </contact:check>
             </check>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-info" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <info>
               <contact:info
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
               </contact:info>
             </info>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-transfer" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <transfer op="query">
               <contact:transfer
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
                 <contact:authInfo>
                   <contact:pw>2fooBAR</contact:pw>
                 </contact:authInfo>
               </contact:transfer>
             </transfer>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-create" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <create>
               <contact:create
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
                 <contact:postalInfo type="int">
                   <contact:name>John Doe</contact:name>
                   <contact:org>Example Inc.</contact:org>
                   <contact:addr>
                     <contact:street>123 Example Dr.</contact:street>
                     <contact:street>Suite 100</contact:street>
                     <contact:city>Dulles</contact:city>
                     <contact:sp>VA</contact:sp>
                     <contact:pc>20166-6503</contact:pc>
                     <contact:cc>US</contact:cc>
                   </contact:addr>
                 </contact:postalInfo>
                 <contact:voice x="1234">+1.7035555555</contact:voice>
                 <contact:fax>+1.7035555556</contact:fax>
                 <contact:email>jdoe@example.tld</contact:email>
                 <contact:authInfo>
                   <contact:pw>2fooBAR</contact:pw>
                 </contact:authInfo>
               </contact:create>
             </create>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-delete" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <delete>
               <contact:delete
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
               </contact:delete>
             </delete>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-transfer" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <transfer op="request">
               <contact:transfer
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
                 <contact:authInfo>
                   <contact:pw>2fooBAR</contact:pw>
                 </contact:authInfo>
               </contact:transfer>
             </transfer>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>',

    "contact-update" =>
        '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
         <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0
              epp-1.0.xsd">
           <command>
             <update>
               <contact:update
                xmlns:contact="urn:ietf:params:xml:ns:contact-1.0"
                xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0
                contact-1.0.xsd">
                 <contact:id>sh8013</contact:id>
                 <contact:add>
                   <contact:status s="clientDeleteProhibited"/>
                 </contact:add>
                 <contact:chg>
                   <contact:postalInfo type="int">
                     <contact:org/>
                     <contact:addr>
                       <contact:street>124 Example Dr.</contact:street>
                       <contact:street>Suite 200</contact:street>
                       <contact:city>Dulles</contact:city>
                       <contact:sp>VA</contact:sp>
                       <contact:pc>20166-6503</contact:pc>
                       <contact:cc>US</contact:cc>
                     </contact:addr>
                   </contact:postalInfo>
                   <contact:voice>+1.7034444444</contact:voice>
                   <contact:fax/>
                   <contact:authInfo>
                     <contact:pw>2fooBAR</contact:pw>
                   </contact:authInfo>
                 </contact:chg>
               </contact:update>
             </update>
             <clTRID>ABC-12345</clTRID>
           </command>
         </epp>'
};


for (my $i = 0 ; $i < 100000 ; $i++) {
    foreach my $name (sort keys %{$tests}) {
	my $parser = new ISC::SRS::EPPParser;

	print Dumper($parser);

	print "\n============\n$name $i\n============\n";
	my $req = $parser->parse_string($tests->{$name});
	print Dumper($req);
	print Dumper($parser);
    }
}

