# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: EPPParser.pm,v 1.6 2003/02/15 00:28:37 explorer Exp $

package ISC::SRS::EPPParser;

use strict;
use warnings;

use XML::SAX qw(Namespaces Validation);

use ISC::SRS::SAX::EPPHandler;

our $factory;
our $handler;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION = do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};
    @ISA = qw(Exporter XML::SAX);
    @EXPORT = qw();
    @EXPORT_OK = qw();
    %EXPORT_TAGS = ();

    # add/update a parser
#    XML::SAX->add_parser(q(XML::SAX::PurePerl));

    $factory = new XML::SAX::ParserFactory(
	Required_features => {
	    Validation => 1,
	    Namespaces => 1
        }
    );
    $handler = new ISC::SRS::SAX::EPPHandler;
}

our @EXPORT_OK;


sub new {
    my ($class, %args) = @_;

    $class = ref($class) || $class;
    my $self = bless({}, $class);

    $self = $factory->parser(Handler => $handler);

    return $self;
}

1;
