# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: Connect.pm,v 1.3 2002/12/06 02:21:10 lidl Exp $

package ISC::CC::Direct::Connect;

use strict;
use warnings;

use Carp;

use ISC::CC::Message;
use ISC::CC::Direct;
use ISC::Net::Connect;
use ISC::Net::LengthPrefix;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION = do { my @r = (q$Revision: 1.3 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};
    @ISA = qw(Exporter ISC::CC::Direct);
    @EXPORT = qw();
    @EXPORT_OK = qw();
    %EXPORT_TAGS = ();
}

our @EXPORT_OK;

END {
}

my $sock_count = 0;

sub new {
    my ($class, %args) = @_;

    $class = ref($class) || $class;

    my $self = bless({}, $class);
    $self = $self->SUPER::new(%args);

    my $name;
    if ($args{name}) {
	$name = $args{name};
    } else {
	$name = "CC::Direct::Connect" . $sock_count++;
    }

    $self->{connect_cb} = $args{connect_cb} if ($args{connect_cb});
    $self->{connect_error_cb} = $args{connect_error_cb} if ($args{connect_error_cb});

    my $proto = $args{Proto} || "tcp";

    my %largs;
    $largs{cb} = \&_connect_cb;
    $largs{error_cb} = \&_connect_err;
    $largs{timeout} = $args{timeout} if ($args{timeout});
    $largs{name} = $name;
    $largs{data} = $self;

    if ($proto eq "tcp") {
	$largs{LocalPort} = $args{LocalPort} if ($args{LocalPort});
	$largs{LocalAddr} = $args{LocalAddr} if ($args{LocalAddr});
	$largs{PeerPort} = $args{PeerPort} if ($args{PeerPort});
	$largs{PeerAddr} = $args{PeerAddr} if ($args{PeerAddr});
	$largs{ReuseAddr} = $args{ReuseAddr} if ($args{ReuseAddr});
	$largs{Proto} = "tcp";
    } elsif ($proto eq "local" || $proto eq "unix") {
	$largs{Peer} = $args{Peer} if ($args{Peer});
	$largs{Local} = $args{Local} if ($args{Local});
    } else {
	croak "Unknown protocol type: $proto";
    }
    
    $self->{sock} = new ISC::Net::Connect(%largs);

    return $self;
}

sub DESTROY {
    my ($self) = @_;

    if ($self->{sock}) {
	$self->{sock}->cancel;
    }

    $self->SUPER::DESTROY;
}

sub _msg_cb {
    my $self = shift;

    $self->SUPER::_msg_cb(@_);
}

sub _msg_err {
    my $self = shift;

    $self->SUPER::_msg_err(@_);
}

sub _connect_cb {
    my ($con) = @_;

    my $self = $con->data;

    $self->{lp} = new ISC::Net::LengthPrefix(cb => \&_msg_cb,
					     error_cb => \&_msg_err,
					     socket => $con->socket,
					     data => $self);

    bless($self->{lp}, "ISC::CC::DirectSocket");

    if ($self->{connect_cb}) {
	$self->{connect_cb}->($self->{lp}, $con->socket);
    }
}

sub _connect_err {
    my ($con, $msg) = @_;

    my $self = $con->{data};

    $self->{connect_error_cb}->($self, $msg);
#   $con->socket->close;
    $con->cancel;
}

sub close {
    my ($self) = @_;

    $self->SUPER::close();

    $self->{sock}->cancel;
    $self->{sock} = undef;
}

1;
