#!/usr/bin/awk -f
#
# $Id: order.awk,v 1.1 2002/09/02 06:09:53 jabley Exp $
#
# hard-wired for verisign's exported zone file format, and for the ORG
# apex.

# absolute origin
/^\$ORIGIN / && ($2 ~ /\.$/) {
  origin = $2;
  sub(/\.$/, "", origin);
  next;
}

# relative origin
/^\$ORIGIN / && ($2 !~ /\.$/) {
  origin = $2 "." origin;
  next;
}

# ignore comments and any remaining $ directives
/^[;\$]/ {
  next;
}

# "this" key
/^@/ {
  key = origin;
}

# absolute key
/^[^ ]*\. / {
  key = $1;
  sub(/\.$/, "", key);
}

# relative key
/^[^ ]*[^\. ] / {
  key = $1 "." origin;
}

# create out-of-zone nameservers, and map domains to them
/ NS / && ($3 ~ /\.$/) {
  ns = $3;
  sub(/\.$/, "", ns);
  print "1 " ns >"batch1";
  print "2 " key " " ns >"batch2";
  next;
}

# create in-zone nameservers
(/ A / || / AAAA /) && (key ~ /\.ORG$/) {
  print "3 " key " " $3 >"batch3";
  next;
}

# map domains to in-zone nameservers
/ NS / {
  print "4 " key " " $3 ".ORG" >"batch4";
  next;
}

# ignore everything else
{}

