#!/bin/sh
#
# $Id: makerrp.sh,v 1.1 2002/09/02 06:09:53 jabley Exp $
#
# Generate RRP files for loading

if [ -f org.zone.gz ]; then
  gzip -d org.zone.gz
fi

# generate batch[1234]

date
echo "generating batch files"
rm -f batch[1234]
./order.awk org.zone
date

# sort | uniq each of those, and generate RRP fragments.
#
# note that we could fork a new shell for each of these pipelines,
# if we wanted to to be uber

for n in batch1 batch2 batch3 batch4; do
  date
  echo "generating ${n}.rrp"
  sort ${n} | uniq | ./torrp.awk >${n}.rrp
  date
done

