#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: sendmsg.pl,v 1.12 2002/12/06 21:59:07 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use Data::Dumper;
use Event qw(loop unloop);
use Time::HiRes qw (gettimeofday);

use ISC::CC::Group::Connect;

my $msg = { iter => 0,
	    liter => 0,
	    msg => "msg",
	    body => [ "a", 5, "6" ]
};

my $sock = new ISC::CC::Group::Connect(connect_cb => \&_connect_cb,
				       connect_error_cb => \&_connect_err,
				       error_cb => \&_msg_err,
				       timeout => 10);


Event->timer(cb => \&_tick, interval => 1);

my $transactions = 0;
my $start = gettimeofday;

sub _tick {
    my ($ev) = @_;

    my $now = gettimeofday;
    my $interval = $now - $start;
    $start = $now;

    if ($transactions) {
	printf("%04d done in %8.3f seconds (%8.4f/sec)\n",
	       $transactions, $interval, $transactions / $interval);
	$transactions = 0;
    }

    $sock->get_stats;
}

sub _connect_cb {
    my ($g, $sock) = @_;

    warn "connected, local name is " . $g->myname;

    my $c = $g->join(group => "foo",
		     instance => "fooinst",
		     cb => \&_group_foo_cb);
    eval {
	$c->send(msg => { hello => "hello" },
		 data => "foo");
    };
}

sub _connect_err {
    my ($foo, $msg) = @_;

    warn "ERROR: $msg";
    unloop();
}

sub _msg_err {
    my ($lp, $msg) = @_;

    print "Error on socket: " . $lp->name . ": $msg\n";
    unloop();
}

sub _group_foo_cb {
    my ($c, $msg, $wmsg) = @_;

    $transactions++;

    if (!defined($msg)) {
	die "timeout!";
    }

#    print Data::Dumper->Dump([$wmsg, $msg], ["wmsg", "msg"]);

    eval {
	$c->send(msg => $msg, cb => \&_reply_callback, data => "foo");
    };
}

sub _reply_callback {
    my ($c, $msg, $wmsg) = @_;

    $transactions++;

    my $data = $c->data;

    eval {
	$c->send(msg => $msg, cb => \&_reply_callback, data => "foo");
    };

#    print Data::Dumper->Dump([$data, $wmsg, $msg], ["data", "msg", "wmsg"]);
}

$SIG{PIPE} = "IGNORE";

$Event::DIED = sub {
    Event::verbose_exception_handler(@_);
    Event::unloop_all();
};

Event::loop();
