#!/bin/sh
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: measure_dig.sh,v 1.5 2002/12/06 21:38:44 lidl Exp $

#
# execute some canned DIG queries against some nameservers, and record
# the reported "total query time".

STEP=60
HB=240

STATS=/var/org/stats

for ns in ns1.tld.isc.org; do
  RRD=${STATS}/${ns}:dig.rrd
  qt=`dig @${ns} ns org.isc.org | awk '/Total query time:/ { print $5; }'`

  if [ ! -f $RRD ]; then
    rrdtool create ${RRD} --step ${STEP} \
       DS:dig_time_ms:GAUGE:${HB}:0:5000 \
       RRA:AVERAGE:0.5:1:6000            \
       AVERAGE:0.5:5:1200                \
       AVERAGE:0.5:60:960                \
       AVERAGE:0.5:1440:2000             \
       MIN:0.5:60:960                    \
       MIN:0.5:1440:2000                 \
       MAX:0.5:60:960                    \
       MAX:0.5:1440:2000
  fi

  rrdtool update ${RRD} --template dig_time_ms N:${qt}
done

