#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: group-sniff.pl,v 1.4 2002/12/06 01:49:23 lidl Exp $

use lib '@prefix@';

use strict;
use warnings;

use Data::Dumper;
use Event qw(loop unloop);
use Getopt::Long;

use ISC::CC::Group::Connect;

my @groups = ();

my $result = GetOptions("group=s" => \@groups);

my $sock = new ISC::CC::Group::Connect(connect_cb => \&_connect_cb,
				       connect_error_cb => \&_connect_err,
				       error_cb => \&_msg_err);

sub _connect_cb {
    my ($gc, $sock) = @_;

    warn "connected, local name is " . $gc->myname;

    foreach my $g (@groups) {
	my ($group, $instance) = split(/\./, $g);
	my %args = (group => $group, cb => \&_group_cb);
	$args{instance} = $instance if ($instance);
	$args{subtype} = "promisc";

	print "subscribing to group $group";
	print " instance $instance" if ($instance);
	print "\n";

	my $c = $gc->join(%args);
    }
}

sub _connect_err {
    my ($foo, $msg) = @_;

    warn "ERROR: $msg";
    unloop();
}

sub _msg_err {
    my ($lp) = @_;

    print "Error on socket: " . $lp->name . "\n";
    unloop();
}

sub _group_cb {
    my ($c, $msg, $wmsg) = @_;

    print Data::Dumper->Dump([$wmsg, $msg], ["wmsg", "msg"]);
}

$Event::DIED = sub {
    Event::verbose_exception_handler(@_);
    Event::unloop_all();
};

Event::loop();
