/*
 * Copyright (c) 1996-2000 by Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/*
 * ignore all name server control statements as this is not a real name server!
 */
#include "port_before.h"

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>

#include <netinet/in.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <resolv.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>

#include <isc/eventlib.h>
#include <isc/logging.h>
#include <isc/memcluster.h>

#include "port_after.h"

#include "named.h"

/* Defs. */

#define CONTROL_FOUND	0x0001	/* for mark and sweep. */
#define	MAX_STR_LEN	500

struct control {
	LINK(struct control) link;
	enum { t_dead, t_inet, t_unix } type;
	struct ctl_sctx *sctx;
	u_int flags;
	union {
		struct {
			struct sockaddr_in in;
			ip_match_list allow;
		} v_inet;
#ifndef NO_SOCKADDR_UN
		struct {
			struct sockaddr_un un;
			mode_t mode;
			uid_t owner;
			gid_t group;
		} v_unix;
#endif
	} var;
};


void			
ns_ctl_initialize(void)
{
	return;
}

void			
ns_ctl_shutdown(void)
{
	return;
}

void			
ns_ctl_defaults(controls *cp)
{
	return;
}

void			
ns_ctl_add(controls *cp, control c)
{
	return;
}

control			
ns_ctl_new_inet(struct in_addr a, u_int i, ip_match_list m)
{
	return NULL;
}

control			
ns_ctl_new_unix(const char *c, mode_t m, uid_t u, gid_t g)
{
	return NULL;
}

void			
ns_ctl_install(controls *cp)
{
	return;
}

