#include "port_before.h"

#include <syslog.h>
#include <sys/socket.h>
#include <ws2tcpip.h>
#include <net/if.h>

#include "port_after.h"

/*
 * Enumerate the TCP/IP interfaces on this machine.
 * Use WSAIoctl() to do this - note that this often
 * does not enumerate the loopback interface.
 *
 * It is the caller's responsibility to free elements
 * of IFData malloc'd by us.
 */
int GetInterfacesWSAIoctl(struct ifdata *IFData[])
{
    INTERFACE_INFO InterfaceList[20];
	SOCKET s;
    unsigned long bytesReturned, flags;
	int numInterfaces, i;
    struct sockaddr_in* pAddress;
	struct in_addr addr, *dest;
	struct ifdata *ifd;
	BOOL ifNamed;

	ntPrintf(6, "Enumerating interfaces via WSAIoctl() - Loopback IF may be missed\n");

	s = socket(AF_INET, SOCK_DGRAM, 0);
    if (s == SOCKET_ERROR)
	{
		ntPrintf(1, "Failed to get a socket.  Error %d\n", GetLastError());
        return 1;
    }

    if ((p_WSAIoctl)(s, SIO_GET_INTERFACE_LIST, 0, 0, &InterfaceList, sizeof(InterfaceList), &bytesReturned, 0, 0) == SOCKET_ERROR)
	{
		ntPrintf(1, "Failed calling WSAIoctl:  Error %d\n", GetLastError());
        return 1;
    }

    numInterfaces = bytesReturned / sizeof(INTERFACE_INFO);

	if(numInterfaces > 0)
	{
		for (i = 0; i < numInterfaces; ++i)
		{
			ifNamed = FALSE;

			ifd = (struct ifdata *)malloc(sizeof(struct ifdata));
			memset(ifd, 0, sizeof(struct ifdata));


			pAddress = (struct sockaddr_in*)&(InterfaceList[i].iiAddress);
			dest = &((struct sockaddr_in *)&ifd->if_addr)->sin_addr;
			memcpy(dest, &pAddress->sin_addr, sizeof(struct in_addr)); 
			ifd->if_addr.sa_family = AF_INET;

			pAddress = (struct sockaddr_in*)&(InterfaceList[i].iiBroadcastAddress);
			dest = &((struct sockaddr_in *)&ifd->if_broadaddr)->sin_addr;
			memcpy(dest, &pAddress->sin_addr, sizeof(struct in_addr)); 
			ifd->if_broadaddr.sa_family = AF_INET;

			flags = InterfaceList[i].iiFlags;
			if (flags & IFF_UP)
				ifd->if_flags |= IFF_UP;
			if (flags & IFF_POINTTOPOINT)
			{
				sprintf(ifd->if_name, "PPP Interface (interface %d)", i);
				ifd->if_flags |= IFF_POINTTOPOINT;
				ifNamed = TRUE;
			}
			if (flags & IFF_LOOPBACK)
			{
				sprintf(ifd->if_name, "Loopback Interface (interface %d)", i);
				ifd->if_flags |= IFF_LOOPBACK;
				ifNamed = TRUE;
			}
			if (flags & IFF_BROADCAST)
				ifd->if_flags |= IFF_BROADCAST;
			if (flags & IFF_MULTICAST)
				ifd->if_flags |= IFF_MULTICAST;

			if(ifNamed == FALSE)
			{
				sprintf(ifd->if_name, "TCP/IP Interface %d", i);
			}

			IFData[i] = ifd;
		}
	}
	else
	{
		ntPrintf(1, "No interfaces found!\n");
	}
    return numInterfaces;
}
