#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93 (BSDI)";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYEMPTY (-1)
#define YYLEX yylex()
#define yyclearin (yychar=YYEMPTY)
#define yyerrok (yyerrflag=0)
#define YYRECOVERING (yyerrflag!=0)
#define YYPREFIX "yy"
#line 2 "ns_parser.y"
#if !defined(lint) && !defined(SABER)
static char rcsid[] = "$Id: ns_parser.y,v 8.7 1997/04/24 23:31:43 vixie Exp $";
#endif /* not lint */

/*
 * Copyright (c) 1996 by Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* Global C stuff goes here. */

#include "port_before.h"

#include <sys/types.h>

#include <netinet/in.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <time.h>

#include "port_after.h"

#include <isc/eventlib.h>
#include <isc/logging.h>

#include "named.h"
#include "ns_lexer.h"
#include "ns_parseutil.h"

#define SYM_ZONE	0x010000
#define SYM_SERVER	0x020000
#define SYM_KEY		0x030000
#define SYM_ACL		0x040000
#define SYM_CHANNEL	0x050000
#define SYM_PORT	0x060000

#define SYMBOL_TABLE_SIZE 29989		/* should always be prime */
static symbol_table symtab;

#define AUTH_TABLE_SIZE 397		/* should always be prime */
static symbol_table authtab = NULL;

static zone_config current_zone;
static int seen_zone;

static options current_options;
static int seen_options;

static topology_config current_topology;
static int seen_topology;

static server_config current_server;
static int seen_server;

static char *current_algorithm;
static char *current_secret;

static log_config current_logging;
static int current_category;
static int chan_type;
static int chan_level;
static u_int chan_flags;
static int chan_facility;
static char *chan_name;
static int chan_versions;
static u_long chan_max_size;

static log_channel lookup_channel(char *);
static void define_channel(char *, log_channel);
static char *canonical_name(char *);

int yyparse();

#line 96 "ns_parser.y"
typedef union {
	char *			cp;
	int			s_int;
	long			num;
	u_long			ul_int;
	u_int16_t		us_int;
	struct in_addr		ip_addr;
	ip_match_element	ime;
	ip_match_list		iml;
	key_info		keyi;
	enum axfr_format	axfr_fmt;
} YYSTYPE;
#line 121 "y.tab.c"
#define L_EOS 257
#define L_IPADDR 258
#define L_NUMBER 259
#define L_STRING 260
#define L_QSTRING 261
#define L_END_INCLUDE 262
#define T_INCLUDE 263
#define T_OPTIONS 264
#define T_DIRECTORY 265
#define T_PIDFILE 266
#define T_NAMED_XFER 267
#define T_FAKE_IQUERY 268
#define T_RECURSION 269
#define T_FETCH_GLUE 270
#define T_QUERY_SOURCE 271
#define T_LISTEN_ON 272
#define T_PORT 273
#define T_ADDRESS 274
#define T_DATASIZE 275
#define T_STACKSIZE 276
#define T_CORESIZE 277
#define T_DEFAULT 278
#define T_UNLIMITED 279
#define T_FILES 280
#define T_TRANSFERS_IN 281
#define T_TRANSFERS_OUT 282
#define T_TRANSFERS_PER_NS 283
#define T_TRANSFER_FORMAT 284
#define T_MAX_TRANSFER_TIME_IN 285
#define T_ONE_ANSWER 286
#define T_MANY_ANSWERS 287
#define T_NOTIFY 288
#define T_AUTH_NXDOMAIN 289
#define T_MULTIPLE_CNAMES 290
#define T_LOGGING 291
#define T_CATEGORY 292
#define T_CHANNEL 293
#define T_SEVERITY 294
#define T_DYNAMIC 295
#define T_FILE 296
#define T_VERSIONS 297
#define T_SIZE 298
#define T_SYSLOG 299
#define T_DEBUG 300
#define T_NULL_OUTPUT 301
#define T_PRINT_TIME 302
#define T_PRINT_CATEGORY 303
#define T_PRINT_SEVERITY 304
#define T_TOPOLOGY 305
#define T_SERVER 306
#define T_LONG_AXFR 307
#define T_BOGUS 308
#define T_TRANSFERS 309
#define T_KEYS 310
#define T_ZONE 311
#define T_IN 312
#define T_CHAOS 313
#define T_HESIOD 314
#define T_TYPE 315
#define T_MASTER 316
#define T_SLAVE 317
#define T_STUB 318
#define T_RESPONSE 319
#define T_HINT 320
#define T_MASTERS 321
#define T_ACL 322
#define T_ALLOW_UPDATE 323
#define T_ALLOW_QUERY 324
#define T_ALLOW_TRANSFER 325
#define T_SEC_KEY 326
#define T_ALGID 327
#define T_SECRET 328
#define T_CHECK_NAMES 329
#define T_WARN 330
#define T_FAIL 331
#define T_IGNORE 332
#define T_FORWARD 333
#define T_FORWARDERS 334
#define T_ONLY 335
#define T_FIRST 336
#define T_IF_NO_ANSWER 337
#define T_IF_NO_DOMAIN 338
#define T_YES 339
#define T_TRUE 340
#define T_NO 341
#define T_FALSE 342
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,   25,   25,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   27,   34,   28,   35,   35,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   38,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,    5,    5,    4,    4,    3,    3,   43,   44,
   40,   40,   40,   40,    2,    2,   23,   23,   23,   23,
   23,   21,   21,   21,   22,   22,   22,   37,   37,   37,
   37,   41,   41,   41,   41,   20,   20,   20,   20,   42,
   42,   42,   39,   39,   45,   45,   46,   47,   29,   48,
   48,   48,   50,   49,   52,   49,   54,   54,   54,   54,
   55,   55,   56,   57,   57,   57,   57,   57,   58,    9,
    9,   10,   10,   59,   60,   60,   60,   60,   60,   60,
   60,   53,   53,   53,    8,    8,   61,   51,   51,   51,
    7,    7,    7,    6,   62,   30,   63,   63,   64,   64,
   64,   64,   64,   14,   14,   12,   12,   11,   11,   11,
   11,   11,   13,   17,   66,   65,   65,   65,   67,   33,
   68,   68,   68,   18,   19,   32,   70,   31,   69,   69,
   15,   15,   16,   16,   16,   16,   71,   71,   72,   72,
   72,   72,   72,   72,   72,   72,   72,   72,   73,   73,
   74,    1,   24,   24,
};
short yylen[] = {                                         2,
    1,    1,    2,    1,    2,    2,    2,    2,    2,    2,
    1,    2,    2,    3,    0,    5,    2,    3,    0,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    3,    5,
    2,    0,    5,    2,    4,    4,    4,    1,    1,    2,
    2,    1,    1,    1,    1,    1,    1,    1,    2,    2,
    1,    1,    2,    2,    0,    2,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    2,    2,    2,    1,    1,    1,    1,    2,
    2,    2,    0,    1,    2,    3,    1,    0,    5,    2,
    3,    1,    0,    6,    0,    6,    1,    1,    2,    1,
    2,    2,    2,    0,    1,    1,    2,    2,    3,    1,
    1,    0,    1,    2,    1,    1,    1,    2,    2,    2,
    2,    2,    3,    1,    1,    1,    1,    2,    3,    1,
    1,    1,    1,    1,    0,    6,    2,    3,    2,    2,
    2,    4,    1,    2,    3,    1,    2,    1,    3,    3,
    1,    3,    1,    1,    1,    2,    3,    1,    0,    6,
    2,    2,    1,    3,    3,    5,    0,    5,    0,    3,
    0,    1,    1,    1,    1,    1,    2,    3,    2,    2,
    4,    2,    4,    4,    4,    2,    2,    1,    2,    3,
    1,    1,    1,    1,
};
short yydefred[] = {                                      0,
    0,   11,    0,   15,   88,    0,    0,    0,  159,    0,
    0,    2,    4,    0,    0,    0,    0,    0,    0,   12,
   13,    0,    0,    0,  135,    0,  193,  194,    0,    0,
    3,    5,    6,    7,    8,    9,   10,   14,    0,    0,
    0,  167,  172,    0,    0,   42,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   32,    0,    0,   38,   39,   92,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  146,    0,  151,
    0,  153,    0,   20,   22,   21,   61,   57,   58,   59,
   60,   23,   24,   25,    0,    0,   34,    0,    0,    0,
    0,   77,   78,   79,   72,   76,   73,   74,   75,   80,
   81,   82,   43,   44,   40,   41,   26,   27,   28,    0,
    0,    0,   62,   63,   64,    0,   68,   69,   70,   71,
   31,    0,   16,    0,   17,  132,  133,   93,  134,  131,
  126,   95,  125,   89,    0,   90,  143,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  147,  144,
  166,    0,  163,    0,    0,    0,    0,    0,  192,   48,
   47,   50,   45,   46,   49,   53,   54,   56,    0,    0,
    0,    0,   65,   66,   67,   29,    0,   18,    0,    0,
   91,  141,  139,  140,    0,  136,    0,  137,  188,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  149,  150,  152,  145,    0,    0,  161,  162,  160,    0,
   37,   35,   36,   87,    0,    0,    0,    0,    0,  158,
  155,  154,    0,    0,  138,  186,  187,  180,  173,  174,
  176,  175,  179,    0,    0,    0,    0,  182,  170,    0,
  177,  164,  165,   30,   33,    0,   85,  130,  127,    0,
    0,  124,    0,    0,    0,  117,    0,    0,    0,    0,
  115,  116,    0,  142,    0,  156,  191,    0,    0,    0,
    0,    0,  178,   86,   94,    0,  128,  100,    0,   97,
  118,    0,  111,  113,  114,  110,  119,  120,  121,   96,
    0,  122,  157,  181,    0,  189,  183,  184,  185,  129,
   99,    0,    0,    0,    0,  109,  123,  190,  101,  102,
  103,  107,  108,
};
short yydgoto[] = {                                      10,
  181,  111,  182,  185,  125,  148,  149,  269,  304,  305,
   88,   89,   90,   91,   42,  253,  241,  176,  177,  115,
  136,  196,  102,   92,   11,   12,   13,   14,   15,   16,
   17,   18,   19,   23,   73,   74,  141,  142,  235,  107,
   75,   76,  108,  109,  236,  237,   24,   80,   81,  199,
  270,  200,  280,  301,  324,  325,  326,  281,  282,  283,
  271,   41,  162,  163,  243,  244,   30,  178,  165,   83,
  219,  220,  288,  289,
};
short yysindex[] = {                                    111,
 -189,    0, -228,    0,    0, -222, -218, -103,    0,    0,
  111,    0,    0, -211, -199, -197, -195, -188, -180,    0,
    0, -164,  -69,  -21,    0, -103,    0,    0,  -13, -103,
    0,    0,    0,    0,    0,    0,    0,    0,   67, -240,
  -10,    0,    0,   30,   -3,    0, -128, -126, -119, -214,
 -214, -214,  -92, -129,  -50,  -50,  -50,  -50, -109, -107,
  -94, -112,  -90, -214, -214, -214,   37,   39,   54, -179,
 -206,    0,   36,  -73,    0,    0,    0, -166, -223, -120,
  -68, -227,   76,  156,  158,   30,  -34,    0,  -44,    0,
  -27,    0, -243,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -38,  -35,    0,  -54,  -52,  -39,
  120,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   30,
   30,   30,    0,    0,    0, -137,    0,    0,    0,    0,
    0,  125,    0,   -7,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    3,    0,    0, -112, -214,    2,
  126, -108,    6, -224,    0,    5,    7,  -19,    0,    0,
    0,   16,    0, -103, -103,  -77,  -53,  150,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   30,  -14,
   -6,   -2,    0,    0,    0,    0,   35,    0,  171,  172,
    0,    0,    0,    0, -153,    0,   40,    0,    0,   41,
 -214,   38, -230,  173,  175,  186,  187, -137, -117,   57,
    0,    0,    0,    0,   65,   70,    0,    0,    0,   11,
    0,    0,    0,    0,  203,   35,   72, -226,   84,    0,
    0,    0,  -97,   73,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   87,   30,   30,   30,    0,    0,   74,
    0,    0,    0,    0,    0,   89,    0,    0,    0, -105,
   96,    0, -221,   93, -219,    0, -214, -214, -214, -116,
    0,    0,  101,    0,  102,    0,    0,  -99,  105,   18,
   22,   26,    0,    0,    0,  106,    0,    0,  107,    0,
    0,  -80,    0,    0,    0,    0,    0,    0,    0,    0,
  114,    0,    0,    0,  119,    0,    0,    0,    0,    0,
    0, -203,  -50,   66,   71,    0,    0,    0,    0,    0,
    0,    0,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  377,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -111,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  122,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  258,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  122,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  127,  132,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  133,  136,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  257,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  269,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  140,    0,
    0,  141,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  142,  146,    0,    0,    0,    0,    0,
    0,    0,    0,
};
short yygindex[] = {                                      0,
  294,    0,    0,    0,  247,    0,    0,  327,    0,    0,
  320,  -76,    0,  -65,    0,    0,    0,  231,  233,  -55,
    0,  192,  -41,   -8,    0,  400,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  339,    0,    0,    0,    0,
    0,    0,  304,  306,    0,  179,    0,    0,  336,    0,
    0,    0,    0,    0,   94,   97,    0,    0,    0,  143,
  148,    0,    0,  262,    0,  177,    0,    0,    0,    0,
    0,  206,    0,  139,
};
#define YYTABLESIZE 437
short yytable[] = {                                      29,
  117,  118,  119,  180,  154,   87,  184,  259,  310,  103,
  104,  171,  173,   87,  172,   77,  206,   43,   87,  295,
  168,   45,  127,  128,  129,  314,   87,  284,  157,  268,
   87,  209,   22,   27,   28,   25,   27,   28,   27,   28,
   27,   28,   26,   87,   97,   32,  116,  116,  116,  116,
   87,   78,   79,   39,   87,  329,  158,   33,   87,   34,
  210,   35,   87,  211,  190,  191,  192,   20,   36,  150,
  153,  212,   21,  298,  151,  330,   37,  151,  299,  303,
  159,  160,  161,  174,  175,  249,  250,  251,   86,  252,
  213,  172,   38,   27,   28,   86,  214,  171,  215,  216,
  217,   40,  240,   86,  218,  223,   27,   28,   86,   44,
  231,  146,   82,  172,  172,  172,   86,  203,  232,   93,
   86,  147,  233,  230,   98,   99,  100,  101,  137,  138,
  139,  140,   94,   86,   95,  264,  133,  134,  209,  135,
   86,   96,  317,  110,   86,  171,  318,  157,   86,  120,
  319,  121,   86,  172,   27,   28,   27,   28,  287,  130,
  143,  131,   27,   28,  122,  225,  226,  210,  126,  247,
  211,   78,   79,  123,  124,  158,  132,  273,  212,  274,
  105,  106,  275,  145,  276,  277,  278,  279,  156,  290,
  291,  292,  193,  194,  195,  151,  242,  213,  164,  159,
  160,  161,  166,  214,  167,  215,  216,  217,  112,   27,
   28,  218,  170,  172,  172,  172,  322,  323,  105,  179,
  179,  106,  183,   84,   85,   27,   28,  113,  114,  153,
   84,   85,   27,   28,  242,  307,  308,  309,   84,   85,
   27,   28,  189,   84,   85,   27,   28,  197,  205,  198,
  175,   84,   85,   27,   28,   84,   85,   27,   28,  201,
  204,  153,  208,  221,  300,  222,  306,  331,   84,   85,
   27,   28,  224,  174,  229,   84,   85,   27,   28,   84,
   85,   27,   28,   84,   85,   27,   28,   84,   85,   27,
   28,   46,  234,  238,  239,  254,  245,  255,  248,  246,
   47,   48,   49,   50,   51,   52,   53,   54,  256,  257,
   55,   56,   57,  261,  116,   58,   59,   60,   61,   62,
   63,  262,   46,   64,   65,   66,  263,  265,  267,  286,
  293,   47,   48,   49,   50,   51,   52,   53,   54,  272,
   67,   55,   56,   57,  287,  294,   58,   59,   60,   61,
   62,   63,  297,  302,   64,   65,   66,  312,  313,   68,
   69,  316,  320,  323,   70,  321,    1,  322,   71,   72,
  327,   67,    2,    3,    4,  328,    1,  273,   19,  274,
   55,   83,  275,  169,  276,  277,  278,  279,  148,   51,
   68,   69,   52,   84,  112,   70,   98,  104,  105,   71,
   72,    5,  106,  188,  202,  152,  169,  228,  227,  258,
   31,  144,  187,  186,  266,  155,    6,  296,  333,  285,
  332,    7,  311,  207,  260,    0,  315,    0,    0,    0,
    0,    0,    8,    0,    0,    0,    9,
};
short yycheck[] = {                                       8,
   56,   57,   58,   42,  125,   33,   42,  125,  125,   51,
   52,  123,  256,   33,   91,  256,  125,   26,   33,  125,
   86,   30,   64,   65,   66,  125,   33,  125,  256,  256,
   33,  256,  261,  260,  261,  258,  260,  261,  260,  261,
  260,  261,  261,   33,  259,  257,   55,   56,   57,   58,
   33,  292,  293,  123,   33,  259,  284,  257,   33,  257,
  285,  257,   33,  288,  130,  131,  132,  257,  257,   78,
   79,  296,  262,  295,  301,  279,  257,  301,  300,  299,
  308,  309,  310,  327,  328,  316,  317,  318,  123,  320,
  315,  168,  257,  260,  261,  123,  321,  125,  323,  324,
  325,  123,  256,  123,  329,  125,  260,  261,  123,  123,
  125,  278,  123,  190,  191,  192,  123,  159,  125,  123,
  123,  288,  125,  189,  339,  340,  341,  342,  335,  336,
  337,  338,  261,  123,  261,  125,  316,  317,  256,  319,
  123,  261,  125,  273,  123,  257,  125,  256,  123,  259,
  125,  259,  123,  230,  260,  261,  260,  261,  258,  123,
  125,  123,  260,  261,  259,  174,  175,  285,  259,  211,
  288,  292,  293,  286,  287,  284,  123,  294,  296,  296,
  273,  274,  299,  257,  301,  302,  303,  304,  257,  255,
  256,  257,  330,  331,  332,  301,  205,  315,  123,  308,
  309,  310,   47,  321,   47,  323,  324,  325,  259,  260,
  261,  329,  257,  290,  291,  292,  297,  298,  273,  259,
  259,  274,  258,  258,  259,  260,  261,  278,  279,  238,
  258,  259,  260,  261,  243,  277,  278,  279,  258,  259,
  260,  261,  123,  258,  259,  260,  261,  123,  123,  257,
  328,  258,  259,  260,  261,  258,  259,  260,  261,  257,
  259,  270,  257,  259,  273,  259,  275,  323,  258,  259,
  260,  261,  257,  327,  125,  258,  259,  260,  261,  258,
  259,  260,  261,  258,  259,  260,  261,  258,  259,  260,
  261,  256,  258,  123,  123,  123,  257,  123,  261,  259,
  265,  266,  267,  268,  269,  270,  271,  272,  123,  123,
  275,  276,  277,  257,  323,  280,  281,  282,  283,  284,
  285,  257,  256,  288,  289,  290,  257,  125,  257,  257,
  257,  265,  266,  267,  268,  269,  270,  271,  272,  256,
  305,  275,  276,  277,  258,  257,  280,  281,  282,  283,
  284,  285,  257,  261,  288,  289,  290,  257,  257,  324,
  325,  257,  257,  298,  329,  259,  256,  297,  333,  334,
  257,  305,  262,  263,  264,  257,    0,  294,  257,  296,
  123,  125,  299,  257,  301,  302,  303,  304,  257,  257,
  324,  325,  257,  125,  257,  329,  257,  257,  257,  333,
  334,  291,  257,  110,  158,   79,   87,  177,  176,  218,
   11,   73,  109,  108,  236,   80,  306,  270,  325,  243,
  324,  311,  280,  162,  219,   -1,  288,   -1,   -1,   -1,
   -1,   -1,  322,   -1,   -1,   -1,  326,
};
#define YYFINAL 10
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 342
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"'!'",0,0,0,0,0,0,0,0,"'*'",0,0,0,0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"L_EOS",
"L_IPADDR","L_NUMBER","L_STRING","L_QSTRING","L_END_INCLUDE","T_INCLUDE",
"T_OPTIONS","T_DIRECTORY","T_PIDFILE","T_NAMED_XFER","T_FAKE_IQUERY",
"T_RECURSION","T_FETCH_GLUE","T_QUERY_SOURCE","T_LISTEN_ON","T_PORT",
"T_ADDRESS","T_DATASIZE","T_STACKSIZE","T_CORESIZE","T_DEFAULT","T_UNLIMITED",
"T_FILES","T_TRANSFERS_IN","T_TRANSFERS_OUT","T_TRANSFERS_PER_NS",
"T_TRANSFER_FORMAT","T_MAX_TRANSFER_TIME_IN","T_ONE_ANSWER","T_MANY_ANSWERS",
"T_NOTIFY","T_AUTH_NXDOMAIN","T_MULTIPLE_CNAMES","T_LOGGING","T_CATEGORY",
"T_CHANNEL","T_SEVERITY","T_DYNAMIC","T_FILE","T_VERSIONS","T_SIZE","T_SYSLOG",
"T_DEBUG","T_NULL_OUTPUT","T_PRINT_TIME","T_PRINT_CATEGORY","T_PRINT_SEVERITY",
"T_TOPOLOGY","T_SERVER","T_LONG_AXFR","T_BOGUS","T_TRANSFERS","T_KEYS","T_ZONE",
"T_IN","T_CHAOS","T_HESIOD","T_TYPE","T_MASTER","T_SLAVE","T_STUB","T_RESPONSE",
"T_HINT","T_MASTERS","T_ACL","T_ALLOW_UPDATE","T_ALLOW_QUERY",
"T_ALLOW_TRANSFER","T_SEC_KEY","T_ALGID","T_SECRET","T_CHECK_NAMES","T_WARN",
"T_FAIL","T_IGNORE","T_FORWARD","T_FORWARDERS","T_ONLY","T_FIRST",
"T_IF_NO_ANSWER","T_IF_NO_DOMAIN","T_YES","T_TRUE","T_NO","T_FALSE",
};
char *yyrule[] = {
"$accept : config_file",
"config_file : statement_list",
"statement_list : statement",
"statement_list : statement_list statement",
"statement : include_stmt",
"statement : options_stmt L_EOS",
"statement : logging_stmt L_EOS",
"statement : server_stmt L_EOS",
"statement : zone_stmt L_EOS",
"statement : acl_stmt L_EOS",
"statement : key_stmt L_EOS",
"statement : L_END_INCLUDE",
"statement : error L_EOS",
"statement : error L_END_INCLUDE",
"include_stmt : T_INCLUDE L_QSTRING L_EOS",
"$$1 :",
"options_stmt : T_OPTIONS $$1 '{' options '}'",
"options : option L_EOS",
"options : options option L_EOS",
"option :",
"option : T_DIRECTORY L_QSTRING",
"option : T_NAMED_XFER L_QSTRING",
"option : T_PIDFILE L_QSTRING",
"option : T_FAKE_IQUERY yea_or_nay",
"option : T_RECURSION yea_or_nay",
"option : T_FETCH_GLUE yea_or_nay",
"option : T_NOTIFY yea_or_nay",
"option : T_AUTH_NXDOMAIN yea_or_nay",
"option : T_MULTIPLE_CNAMES yea_or_nay",
"option : T_CHECK_NAMES check_names_type check_names_opt",
"option : T_LISTEN_ON maybe_port '{' address_match_list '}'",
"option : T_FORWARD forward_opt",
"$$2 :",
"option : T_FORWARDERS $$2 '{' opt_forwarders_list '}'",
"option : T_QUERY_SOURCE query_source",
"option : T_ALLOW_QUERY '{' address_match_list '}'",
"option : T_ALLOW_TRANSFER '{' address_match_list '}'",
"option : T_TOPOLOGY '{' address_match_list '}'",
"option : size_clause",
"option : transfer_clause",
"option : T_TRANSFER_FORMAT transfer_format",
"option : T_MAX_TRANSFER_TIME_IN L_NUMBER",
"option : error",
"transfer_format : T_ONE_ANSWER",
"transfer_format : T_MANY_ANSWERS",
"maybe_wild_addr : L_IPADDR",
"maybe_wild_addr : '*'",
"maybe_wild_port : in_port",
"maybe_wild_port : '*'",
"query_source_address : T_ADDRESS maybe_wild_addr",
"query_source_port : T_PORT maybe_wild_port",
"query_source : query_source_address",
"query_source : query_source_port",
"query_source : query_source_address query_source_port",
"query_source : query_source_port query_source_address",
"maybe_port :",
"maybe_port : T_PORT in_port",
"yea_or_nay : T_YES",
"yea_or_nay : T_TRUE",
"yea_or_nay : T_NO",
"yea_or_nay : T_FALSE",
"yea_or_nay : L_NUMBER",
"check_names_type : T_MASTER",
"check_names_type : T_SLAVE",
"check_names_type : T_RESPONSE",
"check_names_opt : T_WARN",
"check_names_opt : T_FAIL",
"check_names_opt : T_IGNORE",
"forward_opt : T_ONLY",
"forward_opt : T_FIRST",
"forward_opt : T_IF_NO_ANSWER",
"forward_opt : T_IF_NO_DOMAIN",
"size_clause : T_DATASIZE size_spec",
"size_clause : T_STACKSIZE size_spec",
"size_clause : T_CORESIZE size_spec",
"size_clause : T_FILES size_spec",
"size_spec : any_string",
"size_spec : L_NUMBER",
"size_spec : T_DEFAULT",
"size_spec : T_UNLIMITED",
"transfer_clause : T_TRANSFERS_IN L_NUMBER",
"transfer_clause : T_TRANSFERS_OUT L_NUMBER",
"transfer_clause : T_TRANSFERS_PER_NS L_NUMBER",
"opt_forwarders_list :",
"opt_forwarders_list : forwarders_in_addr_list",
"forwarders_in_addr_list : forwarders_in_addr L_EOS",
"forwarders_in_addr_list : forwarders_in_addr_list forwarders_in_addr L_EOS",
"forwarders_in_addr : L_IPADDR",
"$$3 :",
"logging_stmt : T_LOGGING $$3 '{' logging_opts_list '}'",
"logging_opts_list : logging_opt L_EOS",
"logging_opts_list : logging_opts_list logging_opt L_EOS",
"logging_opts_list : error",
"$$4 :",
"logging_opt : T_CATEGORY category $$4 '{' channel_list '}'",
"$$5 :",
"logging_opt : T_CHANNEL channel_name $$5 '{' channel_opt_list '}'",
"channel_severity : any_string",
"channel_severity : T_DEBUG",
"channel_severity : T_DEBUG L_NUMBER",
"channel_severity : T_DYNAMIC",
"version_modifier : T_VERSIONS L_NUMBER",
"version_modifier : T_VERSIONS T_UNLIMITED",
"size_modifier : T_SIZE size_spec",
"maybe_file_modifiers :",
"maybe_file_modifiers : version_modifier",
"maybe_file_modifiers : size_modifier",
"maybe_file_modifiers : version_modifier size_modifier",
"maybe_file_modifiers : size_modifier version_modifier",
"channel_file : T_FILE L_QSTRING maybe_file_modifiers",
"facility_name : any_string",
"facility_name : T_SYSLOG",
"maybe_syslog_facility :",
"maybe_syslog_facility : facility_name",
"channel_syslog : T_SYSLOG maybe_syslog_facility",
"channel_opt : channel_file",
"channel_opt : channel_syslog",
"channel_opt : T_NULL_OUTPUT",
"channel_opt : T_SEVERITY channel_severity",
"channel_opt : T_PRINT_TIME yea_or_nay",
"channel_opt : T_PRINT_CATEGORY yea_or_nay",
"channel_opt : T_PRINT_SEVERITY yea_or_nay",
"channel_opt_list : channel_opt L_EOS",
"channel_opt_list : channel_opt_list channel_opt L_EOS",
"channel_opt_list : error",
"channel_name : any_string",
"channel_name : T_NULL_OUTPUT",
"channel : channel_name",
"channel_list : channel L_EOS",
"channel_list : channel_list channel L_EOS",
"channel_list : error",
"category_name : any_string",
"category_name : T_DEFAULT",
"category_name : T_NOTIFY",
"category : category_name",
"$$6 :",
"server_stmt : T_SERVER L_IPADDR $$6 '{' server_info_list '}'",
"server_info_list : server_info L_EOS",
"server_info_list : server_info_list server_info L_EOS",
"server_info : T_BOGUS yea_or_nay",
"server_info : T_TRANSFERS L_NUMBER",
"server_info : T_TRANSFER_FORMAT transfer_format",
"server_info : T_KEYS '{' key_list '}'",
"server_info : error",
"address_match_list : address_match_element L_EOS",
"address_match_list : address_match_list address_match_element L_EOS",
"address_match_element : address_match_simple",
"address_match_element : '!' address_match_simple",
"address_match_simple : L_IPADDR",
"address_match_simple : L_IPADDR '/' L_NUMBER",
"address_match_simple : L_NUMBER '/' L_NUMBER",
"address_match_simple : address_name",
"address_match_simple : '{' address_match_list '}'",
"address_name : any_string",
"key_ref : any_string",
"key_list_element : key_ref",
"key_list : key_list_element L_EOS",
"key_list : key_list key_list_element L_EOS",
"key_list : error",
"$$7 :",
"key_stmt : T_SEC_KEY $$7 any_string '{' key_definition '}'",
"key_definition : algorithm_id secret",
"key_definition : secret algorithm_id",
"key_definition : error",
"algorithm_id : T_ALGID any_string L_EOS",
"secret : T_SECRET any_string L_EOS",
"acl_stmt : T_ACL any_string '{' address_match_list '}'",
"$$8 :",
"zone_stmt : T_ZONE L_QSTRING optional_class $$8 optional_zone_options_list",
"optional_zone_options_list :",
"optional_zone_options_list : '{' zone_option_list '}'",
"optional_class :",
"optional_class : any_string",
"zone_type : T_MASTER",
"zone_type : T_SLAVE",
"zone_type : T_HINT",
"zone_type : T_STUB",
"zone_option_list : zone_option L_EOS",
"zone_option_list : zone_option_list zone_option L_EOS",
"zone_option : T_TYPE zone_type",
"zone_option : T_FILE L_QSTRING",
"zone_option : T_MASTERS '{' master_in_addr_list '}'",
"zone_option : T_CHECK_NAMES check_names_opt",
"zone_option : T_ALLOW_UPDATE '{' address_match_list '}'",
"zone_option : T_ALLOW_QUERY '{' address_match_list '}'",
"zone_option : T_ALLOW_TRANSFER '{' address_match_list '}'",
"zone_option : T_MAX_TRANSFER_TIME_IN L_NUMBER",
"zone_option : T_NOTIFY yea_or_nay",
"zone_option : error",
"master_in_addr_list : master_in_addr L_EOS",
"master_in_addr_list : master_in_addr_list master_in_addr L_EOS",
"master_in_addr : L_IPADDR",
"in_port : L_NUMBER",
"any_string : L_STRING",
"any_string : L_QSTRING",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
struct yystack {
    short *ssp;
    YYSTYPE *vsp;
    short *ss;
    YYSTYPE *vs;
    int stacksize;
    short *sslim;
};
int yychar; /* some people use this, so we copy it in & out */
int yyerrflag; /* must be global for yyerrok & YYRECOVERING */
YYSTYPE yylval;
#line 1212 "ns_parser.y"

static char *
canonical_name(char *name) {
	char canonical[MAXDNAME];
	
	if (strlen(name) >= MAXDNAME)
		return (NULL);
	strcpy(canonical, name);
	if (makename(canonical, ".", sizeof canonical) < 0)
		return (NULL);
	return (savestr(canonical));
}

static void
init_acls() {
	ip_match_element ime;
	ip_match_list iml;
	struct in_addr address;

	/* Create the predefined ACLs */

	address.s_addr = 0U;

	/* ACL "any" */
	ime = new_ip_match_pattern(address, 0);
	iml = new_ip_match_list();
	add_to_ip_match_list(iml, ime);
	/* define_acl expects the name to be malloc'd memory */
	define_acl(savestr("any"), iml);

	/* ACL "none" */
	ime = new_ip_match_pattern(address, 0);
	ip_match_negate(ime);
	iml = new_ip_match_list();
	add_to_ip_match_list(iml, ime);
	define_acl(savestr("none"), iml);

	/* ACL "localhost" */
	ime = new_ip_match_localhost();
	iml = new_ip_match_list();
	add_to_ip_match_list(iml, ime);
	define_acl(savestr("localhost"), iml);

	/* ACL "localnets" */
	ime = new_ip_match_localnets();
	iml = new_ip_match_list();
	add_to_ip_match_list(iml, ime);
	define_acl(savestr("localnets"), iml);
}

static void
free_sym_value(int type, void *value) {
	ns_debug(ns_log_parser, 99, "free_sym_value: type %06x value %p",
		 type, value);
	type &= ~0xffff;
	switch (type) {
	case SYM_ACL:
		free_ip_match_list(value);
		break;
	case SYM_KEY:
		free_key_info(value);
		break;
	case SYM_CHANNEL:
		ns_panic(ns_log_parser, 1, "channel free in free_sym_value()");
	default:
		if (value != NULL)
			free(value);
	}
}

static log_channel
lookup_channel(char *name) {
	symbol_value value;

	if (lookup_symbol(symtab, name, SYM_CHANNEL, &value))
		return ((log_channel)(value.pointer));
	return (NULL);
}

static void
define_channel(char *name, log_channel channel) {
	symbol_value value;

	value.pointer = channel;  
	define_symbol(symtab, name, SYM_CHANNEL, value, SYMBOL_FREE_KEY);
}

static void
define_builtin_channels() {
	define_channel(savestr("default_syslog"), syslog_channel);
	define_channel(savestr("default_debug"), debug_channel);
	define_channel(savestr("default_stderr"), stderr_channel);
	define_channel(savestr("null"), null_channel);
}

static void
parser_initialize() {
	seen_options = 0;
	seen_topology = 0;
	symtab = new_symbol_table(SYMBOL_TABLE_SIZE, NULL);
	if (authtab != NULL)
		free_symbol_table(authtab);
	authtab = new_symbol_table(AUTH_TABLE_SIZE, free_sym_value);
	init_acls();
	define_builtin_channels();
}

static void
parser_cleanup() {
	if (symtab != NULL)
		free_symbol_table(symtab);
	symtab = NULL;
	/*
	 * We don't clean up authtab here because the ip_match_lists are in
	 * use.
	 */
}

/*
 * Public Interface
 */

ip_match_list
lookup_acl(char *name) {
	symbol_value value;

	if (lookup_symbol(authtab, name, SYM_ACL, &value))
		return ((ip_match_list)(value.pointer));
	return (NULL);
}

void
define_acl(char *name, ip_match_list iml) {
	symbol_value value;

	INSIST(name != NULL);
	INSIST(iml != NULL);

	value.pointer = iml;
	define_symbol(authtab, name, SYM_ACL, value,
		      SYMBOL_FREE_KEY|SYMBOL_FREE_VALUE);
	ns_debug(ns_log_parser, 7, "acl %s", name);
	dprint_ip_match_list(ns_log_parser, iml, 2, "allow ", "deny ");
}

key_info
lookup_key(char *name) {
	symbol_value value;

	if (lookup_symbol(authtab, name, SYM_KEY, &value))
		return ((key_info)(value.pointer));
	return (NULL);
}

void
define_key(char *name, key_info ki) {
	symbol_value value;

	INSIST(name != NULL);
	INSIST(ki != NULL);

	value.pointer = ki;
	define_symbol(authtab, name, SYM_KEY, value, SYMBOL_FREE_VALUE);
	dprint_key_info(ki);
}

void
parse_configuration(const char *filename) {
	FILE *config_stream;

	config_stream = fopen(filename, "r");
	if (config_stream == NULL)
		ns_panic(ns_log_parser, 0, "can't open '%s'", filename);

	lexer_initialize();
	parser_initialize();
	lexer_begin_file(filename, config_stream);
	(void)yyparse();
	lexer_end_file();
	parser_cleanup();
}
#line 909 "y.tab.c"
/* allocate initial stack */
#if defined(__STDC__) || defined(__cplusplus)
static int yyinitstack(struct yystack *sp)
#else
static int yyinitstack(sp)
    struct yystack *sp;
#endif
{
    int newsize;
    short *newss;
    YYSTYPE *newvs;

    newsize = YYINITSTACKSIZE;
    newss = (short *)malloc(newsize * sizeof *newss);
    newvs = (YYSTYPE *)malloc(newsize * sizeof *newvs);
    sp->ss = sp->ssp = newss;
    sp->vs = sp->vsp = newvs;
    if (newss == NULL || newvs == NULL) return -1;
    sp->stacksize = newsize;
    sp->sslim = newss + newsize - 1;
    return 0;
}

/* double stack size, up to YYMAXDEPTH */
#if defined(__STDC__) || defined(__cplusplus)
static int yygrowstack(struct yystack *sp)
#else
static int yygrowstack(sp)
    struct yystack *sp;
#endif
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = sp->stacksize) >= YYMAXDEPTH) return -1;
    if ((newsize *= 2) > YYMAXDEPTH) newsize = YYMAXDEPTH;
    i = sp->ssp - sp->ss;
    if ((newss = (short *)realloc(sp->ss, newsize * sizeof *newss)) == NULL)
        return -1;
    sp->ss = newss;
    sp->ssp = newss + i;
    if ((newvs = (YYSTYPE *)realloc(sp->vs, newsize * sizeof *newvs)) == NULL)
        return -1;
    sp->vs = newvs;
    sp->vsp = newvs + i;
    sp->stacksize = newsize;
    sp->sslim = newss + newsize - 1;
    return 0;
}

#define YYFREESTACK(sp) { free((sp)->ss); free((sp)->vs); }

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate, yych;
    register YYSTYPE *yyvsp;
    YYSTYPE yyval;
    struct yystack yystk;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = yych = YYEMPTY;

    if (yyinitstack(&yystk)) goto yyoverflow;
    *yystk.ssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yych < 0)
    {
        if ((yych = YYLEX) < 0) yych = 0;
        yychar = yych;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yych <= YYMAXTOKEN) yys = yyname[yych];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yych, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yych) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yych)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystk.ssp >= yystk.sslim && yygrowstack(&yystk))
            goto yyoverflow;
        *++yystk.ssp = yystate = yytable[yyn];
        *++yystk.vsp = yylval;
        yychar = yych = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yych) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yych)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystk.ssp]) &&
                    (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystk.ssp, yytable[yyn]);
#endif
                if (yystk.ssp >= yystk.sslim && yygrowstack(&yystk))
                    goto yyoverflow;
                *++yystk.ssp = yystate = yytable[yyn];
                *++yystk.vsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystk.ssp);
#endif
                if (yystk.ssp <= yystk.ss) goto yyabort;
                --yystk.ssp;
                --yystk.vsp;
            }
        }
    }
    else
    {
        if (yych == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yych <= YYMAXTOKEN) yys = yyname[yych];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yych, yys);
        }
#endif
        yychar = yych = YYEMPTY;
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyvsp = yystk.vsp; /* for speed in code under switch() */
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 202 "ns_parser.y"
{
		/* nothing */
	}
break;
case 14:
#line 223 "ns_parser.y"
{ lexer_begin_file(yyvsp[-1].cp, NULL); }
break;
case 15:
#line 231 "ns_parser.y"
{
		if (seen_options)
			parser_error(0, "cannot redefine options");
		current_options = new_options();
	}
break;
case 16:
#line 237 "ns_parser.y"
{
		if (!seen_options)
			set_options(current_options, 0);
		else
			free_options(current_options);
		current_options = NULL;
		seen_options = 1;
	}
break;
case 20:
#line 253 "ns_parser.y"
{
		if (current_options->directory != NULL)
			free(current_options->directory);
		current_options->directory = yyvsp[0].cp;
	}
break;
case 21:
#line 259 "ns_parser.y"
{
		if (current_options->named_xfer != NULL)
			free(current_options->named_xfer);
		current_options->named_xfer = yyvsp[0].cp;
	}
break;
case 22:
#line 265 "ns_parser.y"
{
		if (current_options->pid_filename != NULL)
			free(current_options->pid_filename);
		current_options->pid_filename = yyvsp[0].cp;
	}
break;
case 23:
#line 271 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_FAKE_IQUERY, yyvsp[0].num);
	}
break;
case 24:
#line 275 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_NORECURSE, !yyvsp[0].num);
	}
break;
case 25:
#line 279 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_NOFETCHGLUE, !yyvsp[0].num);
	}
break;
case 26:
#line 283 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_NONOTIFY, !yyvsp[0].num);
	}
break;
case 27:
#line 287 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_NONAUTH_NXDOMAIN,
				   !yyvsp[0].num);
	}
break;
case 28:
#line 292 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_MULTIPLE_CNAMES,
				   yyvsp[0].num);
	}
break;
case 29:
#line 297 "ns_parser.y"
{
		current_options->check_names[yyvsp[-1].s_int] = yyvsp[0].s_int;
	}
break;
case 30:
#line 301 "ns_parser.y"
{
		char port_string[10];
		symbol_value value;

		(void)sprintf(port_string, "%u", yyvsp[-3].us_int);
		if (lookup_symbol(symtab, port_string, SYM_PORT, NULL))
			parser_error(0,
				     "cannot redefine listen-on for port %u",
				     yyvsp[-3].us_int);
		else {
			add_listen_on(current_options, yyvsp[-3].us_int, yyvsp[-1].iml);
			value.pointer = NULL;
			define_symbol(symtab, savestr(port_string), SYM_PORT,
				      value, SYMBOL_FREE_KEY);
		}

	}
break;
case 32:
#line 320 "ns_parser.y"
{
		if (current_options->fwdtab) {
			free_forwarders(current_options->fwdtab);
			current_options->fwdtab = NULL;
		}
	}
break;
case 35:
#line 329 "ns_parser.y"
{
		if (current_options->query_acl)
			free_ip_match_list(current_options->query_acl);
		current_options->query_acl = yyvsp[-1].iml;
	}
break;
case 36:
#line 335 "ns_parser.y"
{
		if (current_options->transfer_acl)
			free_ip_match_list(current_options->transfer_acl);
		current_options->transfer_acl = yyvsp[-1].iml;
	}
break;
case 37:
#line 341 "ns_parser.y"
{
		if (current_options->topology)
			free_ip_match_list(current_options->topology);
		current_options->topology = yyvsp[-1].iml;
	}
break;
case 38:
#line 347 "ns_parser.y"
{
		/* To get around the $$ = $1 default rule. */
	}
break;
case 40:
#line 352 "ns_parser.y"
{
		current_options->transfer_format = yyvsp[0].axfr_fmt;
	}
break;
case 41:
#line 356 "ns_parser.y"
{
		current_options->max_transfer_time_in = yyvsp[0].num * 60;
	}
break;
case 43:
#line 363 "ns_parser.y"
{
		yyval.axfr_fmt = axfr_one_answer;
	}
break;
case 44:
#line 367 "ns_parser.y"
{
		yyval.axfr_fmt = axfr_many_answers;
	}
break;
case 45:
#line 372 "ns_parser.y"
{ yyval.ip_addr = yyvsp[0].ip_addr; }
break;
case 46:
#line 373 "ns_parser.y"
{ yyval.ip_addr.s_addr = htonl(INADDR_ANY); }
break;
case 47:
#line 376 "ns_parser.y"
{ yyval.us_int = yyvsp[0].us_int; }
break;
case 48:
#line 377 "ns_parser.y"
{ yyval.us_int = htons(0); }
break;
case 49:
#line 381 "ns_parser.y"
{
		current_options->query_source.sin_addr = yyvsp[0].ip_addr;
	}
break;
case 50:
#line 387 "ns_parser.y"
{
		current_options->query_source.sin_port = yyvsp[0].us_int;
	}
break;
case 55:
#line 398 "ns_parser.y"
{ yyval.us_int = htons(NS_DEFAULTPORT); }
break;
case 56:
#line 399 "ns_parser.y"
{ yyval.us_int = yyvsp[0].us_int; }
break;
case 57:
#line 403 "ns_parser.y"
{ 
		yyval.num = 1;	
	}
break;
case 58:
#line 407 "ns_parser.y"
{ 
		yyval.num = 1;	
	}
break;
case 59:
#line 411 "ns_parser.y"
{ 
		yyval.num = 0;	
	}
break;
case 60:
#line 415 "ns_parser.y"
{ 
		yyval.num = 0;	
	}
break;
case 61:
#line 419 "ns_parser.y"
{ 
		if (yyvsp[0].num == 1 || yyvsp[0].num == 0) {
			yyval.num = yyvsp[0].num;
		} else {
			parser_warning(0,
				       "number should be 0 or 1; assuming 1");
			yyval.num = 1;
		}
	}
break;
case 62:
#line 431 "ns_parser.y"
{
		yyval.s_int = primary_trans;
	}
break;
case 63:
#line 435 "ns_parser.y"
{
		yyval.s_int = secondary_trans;
	}
break;
case 64:
#line 439 "ns_parser.y"
{
		yyval.s_int = response_trans;
	}
break;
case 65:
#line 445 "ns_parser.y"
{
		yyval.s_int = warn;
	}
break;
case 66:
#line 449 "ns_parser.y"
{
		yyval.s_int = fail;
	}
break;
case 67:
#line 453 "ns_parser.y"
{
		yyval.s_int = ignore;
	}
break;
case 68:
#line 459 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_FORWARD_ONLY, 1);
	}
break;
case 69:
#line 463 "ns_parser.y"
{
		set_boolean_option(current_options, OPTION_FORWARD_ONLY, 0);
	}
break;
case 70:
#line 467 "ns_parser.y"
{
		parser_warning(0, "forward if-no-answer is unimplemented");
	}
break;
case 71:
#line 471 "ns_parser.y"
{
		parser_warning(0, "forward if-no-domain is unimplemented");
	}
break;
case 72:
#line 477 "ns_parser.y"
{
		current_options->data_size = yyvsp[0].ul_int;
	}
break;
case 73:
#line 481 "ns_parser.y"
{
		current_options->stack_size = yyvsp[0].ul_int;
	}
break;
case 74:
#line 485 "ns_parser.y"
{
		current_options->core_size = yyvsp[0].ul_int;
	}
break;
case 75:
#line 489 "ns_parser.y"
{
		current_options->files = yyvsp[0].ul_int;
	}
break;
case 76:
#line 495 "ns_parser.y"
{
		u_long result;

		if (unit_to_ulong(yyvsp[0].cp, &result))
			yyval.ul_int = result;
		else {
			parser_error(0, "invalid unit string '%s'", yyvsp[0].cp);
			/* 0 means "use default" */
			yyval.ul_int = 0;
		}
		free(yyvsp[0].cp);
	}
break;
case 77:
#line 508 "ns_parser.y"
{	
		yyval.ul_int = (u_long)yyvsp[0].num;
	}
break;
case 78:
#line 512 "ns_parser.y"
{
		yyval.ul_int = 0;
	}
break;
case 79:
#line 516 "ns_parser.y"
{
		yyval.ul_int = ULONG_MAX;
	}
break;
case 80:
#line 522 "ns_parser.y"
{
		current_options->transfers_in = (u_long) yyvsp[0].num;
	}
break;
case 81:
#line 526 "ns_parser.y"
{
		current_options->transfers_out = (u_long) yyvsp[0].num;
	}
break;
case 82:
#line 530 "ns_parser.y"
{
		current_options->transfers_per_ns = (u_long) yyvsp[0].num;
	}
break;
case 85:
#line 540 "ns_parser.y"
{
		/* nothing */
	}
break;
case 86:
#line 544 "ns_parser.y"
{
		/* nothing */
	}
break;
case 87:
#line 550 "ns_parser.y"
{
	  	add_forwarder(current_options, yyvsp[0].ip_addr);
	}
break;
case 88:
#line 560 "ns_parser.y"
{
		current_logging = begin_logging();
	}
break;
case 89:
#line 564 "ns_parser.y"
{
		end_logging(current_logging, 1);
	}
break;
case 93:
#line 575 "ns_parser.y"
{
		current_category = yyvsp[0].s_int;
	}
break;
case 95:
#line 580 "ns_parser.y"
{
		chan_type = log_null;
		chan_flags = 0;
		chan_level = log_info;
	}
break;
case 96:
#line 586 "ns_parser.y"
{
		log_channel current_channel = NULL;

		if (lookup_channel(yyvsp[-4].cp) != NULL) {
			parser_error(0, "can't redefine channel '%s'", yyvsp[-4].cp);
			free(yyvsp[-4].cp);
		} else {
			switch (chan_type) {
			case log_file:
				current_channel =
					log_new_file_channel(chan_flags,
							     chan_level,
							     chan_name, NULL,
							     chan_versions,
							     chan_max_size);
				break;
			case log_syslog:
				current_channel =
					log_new_syslog_channel(chan_flags,
							       chan_level,
							       chan_facility);
				break;
			case log_null:
				current_channel = log_new_null_channel();
				break;
			default:
				ns_panic(ns_log_parser, 1,
					 "unknown channel type: %d",
					 chan_type);
			}
			if (current_channel == NULL)
				ns_panic(ns_log_parser, 0,
					 "couldn't create channel");
			define_channel(yyvsp[-4].cp, current_channel);
		}
	}
break;
case 97:
#line 625 "ns_parser.y"
{
		symbol_value value;

		if (lookup_symbol(constants, yyvsp[0].cp, SYM_LOGGING, &value)) {
			chan_level = value.integer;
		} else {
			parser_error(0, "unknown severity '%s'", yyvsp[0].cp);
			chan_level = log_debug(99);
		}
		free(yyvsp[0].cp);
	}
break;
case 98:
#line 637 "ns_parser.y"
{
		chan_level = log_debug(1);
	}
break;
case 99:
#line 641 "ns_parser.y"
{
		chan_level = yyvsp[0].num;
	}
break;
case 100:
#line 645 "ns_parser.y"
{
		chan_level = 0;
		chan_flags |= LOG_USE_CONTEXT_LEVEL|LOG_REQUIRE_DEBUG;
	}
break;
case 101:
#line 652 "ns_parser.y"
{
		chan_versions = yyvsp[0].num;
		chan_flags |= LOG_TRUNCATE;
	}
break;
case 102:
#line 657 "ns_parser.y"
{
		chan_versions = LOG_MAX_VERSIONS;
		chan_flags |= LOG_TRUNCATE;
	}
break;
case 103:
#line 664 "ns_parser.y"
{
		chan_max_size = yyvsp[0].ul_int;
	}
break;
case 104:
#line 670 "ns_parser.y"
{
		chan_versions = 0;
		chan_max_size = ULONG_MAX;
	}
break;
case 105:
#line 675 "ns_parser.y"
{
		chan_max_size = ULONG_MAX;
	}
break;
case 106:
#line 679 "ns_parser.y"
{
		chan_versions = 0;
	}
break;
case 109:
#line 687 "ns_parser.y"
{
		chan_flags |= LOG_CLOSE_STREAM;
		chan_type = log_file;
		chan_name = yyvsp[-1].cp;
	}
break;
case 110:
#line 695 "ns_parser.y"
{ yyval.cp = yyvsp[0].cp; }
break;
case 111:
#line 696 "ns_parser.y"
{ yyval.cp = savestr("syslog"); }
break;
case 112:
#line 699 "ns_parser.y"
{ yyval.s_int = LOG_DAEMON; }
break;
case 113:
#line 701 "ns_parser.y"
{
		symbol_value value;

		if (lookup_symbol(constants, yyvsp[0].cp, SYM_SYSLOG, &value)) {
			yyval.s_int = value.integer;
		} else {
			parser_error(0, "unknown facility '%s'", yyvsp[0].cp);
			yyval.s_int = LOG_DAEMON;
		}
		free(yyvsp[0].cp);
	}
break;
case 114:
#line 715 "ns_parser.y"
{
		chan_type = log_syslog;
		chan_facility = yyvsp[0].s_int;
	}
break;
case 115:
#line 721 "ns_parser.y"
{ /* nothing to do */ }
break;
case 116:
#line 722 "ns_parser.y"
{ /* nothing to do */ }
break;
case 117:
#line 724 "ns_parser.y"
{
		chan_type = log_null;
	}
break;
case 118:
#line 727 "ns_parser.y"
{ /* nothing to do */ }
break;
case 119:
#line 729 "ns_parser.y"
{
		if (yyvsp[0].num)
			chan_flags |= LOG_TIMESTAMP;
		else
			chan_flags &= ~LOG_TIMESTAMP;
	}
break;
case 120:
#line 736 "ns_parser.y"
{
		if (yyvsp[0].num)
			chan_flags |= LOG_PRINT_CATEGORY;
		else
			chan_flags &= ~LOG_PRINT_CATEGORY;
	}
break;
case 121:
#line 743 "ns_parser.y"
{
		if (yyvsp[0].num)
			chan_flags |= LOG_PRINT_LEVEL;
		else
			chan_flags &= ~LOG_PRINT_LEVEL;
	}
break;
case 126:
#line 757 "ns_parser.y"
{ yyval.cp = savestr("null"); }
break;
case 127:
#line 761 "ns_parser.y"
{
		log_channel channel;
		symbol_value value;

		if (current_category >= 0) {
			channel = lookup_channel(yyvsp[0].cp);
			if (channel != NULL) {
				add_log_channel(current_logging,
						current_category, channel);
			} else
				parser_error(0, "unknown channel '%s'", yyvsp[0].cp);
		}
		free(yyvsp[0].cp);
	}
break;
case 132:
#line 783 "ns_parser.y"
{ yyval.cp = savestr("default"); }
break;
case 133:
#line 784 "ns_parser.y"
{ yyval.cp = savestr("notify"); }
break;
case 134:
#line 788 "ns_parser.y"
{
		symbol_value value;

		if (lookup_symbol(constants, yyvsp[0].cp, SYM_CATEGORY, &value))
			yyval.s_int = value.integer;
		else {
			parser_error(0, "invalid logging category '%s'",
				     yyvsp[0].cp);
			yyval.s_int = -1;
		}
		free(yyvsp[0].cp);
	}
break;
case 135:
#line 807 "ns_parser.y"
{
		char *ip_printable;
		symbol_value value;
		
		ip_printable = inet_ntoa(yyvsp[0].ip_addr);
		value.pointer = NULL;
		if (lookup_symbol(symtab, ip_printable, SYM_SERVER, NULL))
			seen_server = 1;
		else
			seen_server = 0;
		if (seen_server)
			parser_error(0, "cannot redefine server '%s'", 
				     ip_printable);
		else
			define_symbol(symtab, savestr(ip_printable),
				      SYM_SERVER, value,
				      SYMBOL_FREE_KEY);
		current_server = begin_server(yyvsp[0].ip_addr);
	}
break;
case 136:
#line 827 "ns_parser.y"
{
		end_server(current_server, !seen_server);
	}
break;
case 139:
#line 837 "ns_parser.y"
{
		set_server_option(current_server, SERVER_INFO_BOGUS, yyvsp[0].num);
	}
break;
case 140:
#line 841 "ns_parser.y"
{
		set_server_transfers(current_server, (int)yyvsp[0].num);
	}
break;
case 141:
#line 845 "ns_parser.y"
{
		set_server_transfer_format(current_server, yyvsp[0].axfr_fmt);
	}
break;
case 144:
#line 857 "ns_parser.y"
{
		ip_match_list iml;
		
		iml = new_ip_match_list();
		if (yyvsp[-1].ime != NULL)
			add_to_ip_match_list(iml, yyvsp[-1].ime);
		yyval.iml = iml;
	}
break;
case 145:
#line 866 "ns_parser.y"
{
		if (yyvsp[-1].ime != NULL)
			add_to_ip_match_list(yyvsp[-2].iml, yyvsp[-1].ime);
		yyval.iml = yyvsp[-2].iml;
	}
break;
case 147:
#line 875 "ns_parser.y"
{
		if (yyvsp[0].ime != NULL)
			ip_match_negate(yyvsp[0].ime);
		yyval.ime = yyvsp[0].ime;
	}
break;
case 148:
#line 883 "ns_parser.y"
{
		yyval.ime = new_ip_match_pattern(yyvsp[0].ip_addr, 32);
	}
break;
case 149:
#line 887 "ns_parser.y"
{
		if (yyvsp[0].num < 0 || yyvsp[0].num > 32) {
			parser_error(0, "mask bits out of range; skipping");
			yyval.ime = NULL;
		} else {
			yyval.ime = new_ip_match_pattern(yyvsp[-2].ip_addr, yyvsp[0].num);
			if (yyval.ime == NULL)
				parser_error(0, 
					   "address/mask mismatch; skipping");
		}
	}
break;
case 150:
#line 899 "ns_parser.y"
{
		struct in_addr ia;

		if (yyvsp[-2].num > 255) {
			parser_error(0, "address out of range; skipping");
			yyval.ime = NULL;
		} else {
			if (yyvsp[0].num < 0 || yyvsp[0].num > 32) {
				parser_error(0,
					"mask bits out of range; skipping");
					yyval.ime = NULL;
			} else {
				ia.s_addr = htonl((yyvsp[-2].num & 0xff) << 24);
				yyval.ime = new_ip_match_pattern(ia, yyvsp[0].num);
				if (yyval.ime == NULL)
					parser_error(0, 
					   "address/mask mismatch; skipping");
			}
		}
	}
break;
case 152:
#line 921 "ns_parser.y"
{
		char name[256];

		/*
		 * We want to be able to clean up this iml later so
		 * we give it a name and treat it like any other acl.
		 */
		sprintf(name, "__internal_%p", yyvsp[-1].iml);
		define_acl(savestr(name), yyvsp[-1].iml);
  		yyval.ime = new_ip_match_indirect(yyvsp[-1].iml);
	}
break;
case 153:
#line 935 "ns_parser.y"
{
		ip_match_list iml;

		iml = lookup_acl(yyvsp[0].cp);
		if (iml == NULL) {
			parser_error(0, "unknown ACL '%s'", yyvsp[0].cp);
			yyval.ime = NULL;
		} else
			yyval.ime = new_ip_match_indirect(iml);
		free(yyvsp[0].cp);
	}
break;
case 154:
#line 953 "ns_parser.y"
{
		key_info ki;

		ki = lookup_key(yyvsp[0].cp);
		if (ki == NULL) {
			parser_error(0, "unknown key '%s'", yyvsp[0].cp);
			yyval.keyi = NULL;
		} else
			yyval.keyi = ki;
		free(yyvsp[0].cp);
	}
break;
case 155:
#line 967 "ns_parser.y"
{
		if (yyvsp[0].keyi == NULL)
			parser_error(0, "empty key not added to server list ");
		else
			add_server_key_info(current_server, yyvsp[0].keyi);
	}
break;
case 159:
#line 981 "ns_parser.y"
{
		current_algorithm = NULL;
		current_secret = NULL;
	}
break;
case 160:
#line 986 "ns_parser.y"
{
		key_info ki;

		if (lookup_key(yyvsp[-3].cp) != NULL) {
			parser_error(0, "can't redefine key '%s'", yyvsp[-3].cp);
			free(yyvsp[-3].cp);
		} else {
			if (current_algorithm == NULL ||
			    current_secret == NULL)
				parser_error(0, "skipping bad key '%s'", yyvsp[-3].cp);
			else {
				ki = new_key_info(yyvsp[-3].cp, current_algorithm,
						  current_secret);
				define_key(yyvsp[-3].cp, ki);
			}
		}
	}
break;
case 161:
#line 1006 "ns_parser.y"
{
		current_algorithm = yyvsp[-1].cp;
		current_secret = yyvsp[0].cp;
	}
break;
case 162:
#line 1011 "ns_parser.y"
{
		current_algorithm = yyvsp[0].cp;
		current_secret = yyvsp[-1].cp;
	}
break;
case 163:
#line 1016 "ns_parser.y"
{
		current_algorithm = NULL;
		current_secret = NULL;
	}
break;
case 164:
#line 1022 "ns_parser.y"
{ yyval.cp = yyvsp[-1].cp; }
break;
case 165:
#line 1025 "ns_parser.y"
{ yyval.cp = yyvsp[-1].cp; }
break;
case 166:
#line 1033 "ns_parser.y"
{
		if (lookup_acl(yyvsp[-3].cp) != NULL) {
			parser_error(0, "can't redefine ACL '%s'", yyvsp[-3].cp);
			free(yyvsp[-3].cp);
		} else
			define_acl(yyvsp[-3].cp, yyvsp[-1].iml);
	}
break;
case 167:
#line 1047 "ns_parser.y"
{
		int sym_type;
		symbol_value value;
		char *zone_name;

		if (!seen_options)
			parser_error(0,
             "no options statement before first zone; using previous/default");
		sym_type = SYM_ZONE | (yyvsp[0].num & 0xffff);
		value.pointer = NULL;
		zone_name = canonical_name(yyvsp[-1].cp);
		if (zone_name == NULL) {
			parser_error(0, "can't make zone name '%s' canonical",
				     yyvsp[-1].cp);
			seen_zone = 1;
			zone_name = savestr("__bad_zone__");
		} else {
			seen_zone = lookup_symbol(symtab, zone_name, sym_type,
						  NULL);
			if (seen_zone) {
				parser_error(0,
					"cannot redefine zone '%s' class %d",
					     zone_name, yyvsp[0].num);
				free(zone_name);
			} else
				define_symbol(symtab, zone_name, sym_type,
					      value, 0);
		}
		free(yyvsp[-1].cp);
		current_zone = begin_zone(zone_name, yyvsp[0].num); 
	}
break;
case 168:
#line 1079 "ns_parser.y"
{ end_zone(current_zone, !seen_zone); }
break;
case 171:
#line 1087 "ns_parser.y"
{
		yyval.num = C_IN;
	}
break;
case 172:
#line 1091 "ns_parser.y"
{
		symbol_value value;

		if (lookup_symbol(constants, yyvsp[0].cp, SYM_CLASS, &value))
			yyval.num = value.integer;
		else {
			/* the zone validator will give the error */
			yyval.num = C_NONE;
		}
		free(yyvsp[0].cp);
	}
break;
case 173:
#line 1105 "ns_parser.y"
{
		yyval.s_int = Z_MASTER;
	}
break;
case 174:
#line 1109 "ns_parser.y"
{
		yyval.s_int = Z_SLAVE;
	}
break;
case 175:
#line 1113 "ns_parser.y"
{
		yyval.s_int = Z_HINT;
	}
break;
case 176:
#line 1117 "ns_parser.y"
{
		yyval.s_int = Z_STUB;
	}
break;
case 179:
#line 1127 "ns_parser.y"
{
		if (!set_zone_type(current_zone, yyvsp[0].s_int))
			parser_warning(0, "zone type already set; skipping");
	}
break;
case 180:
#line 1132 "ns_parser.y"
{
		if (!set_zone_filename(current_zone, yyvsp[0].cp))
			parser_warning(0,
				       "zone filename already set; skipping");
	}
break;
case 182:
#line 1139 "ns_parser.y"
{
		if (!set_zone_checknames(current_zone, yyvsp[0].s_int))
			parser_warning(0,
	                              "zone checknames already set; skipping");
	}
break;
case 183:
#line 1145 "ns_parser.y"
{
		if (!set_zone_update_acl(current_zone, yyvsp[-1].iml))
			parser_warning(0,
				      "zone update acl already set; skipping");
	}
break;
case 184:
#line 1151 "ns_parser.y"
{
		if (!set_zone_query_acl(current_zone, yyvsp[-1].iml))
			parser_warning(0,
				      "zone query acl already set; skipping");
	}
break;
case 185:
#line 1157 "ns_parser.y"
{
		if (!set_zone_transfer_acl(current_zone, yyvsp[-1].iml))
			parser_warning(0,
				    "zone transfer acl already set; skipping");
	}
break;
case 186:
#line 1163 "ns_parser.y"
{
		if (!set_zone_transfer_time_in(current_zone, yyvsp[0].num*60))
			parser_warning(0,
		       "zone max transfer time (in) already set; skipping");
	}
break;
case 187:
#line 1169 "ns_parser.y"
{
		set_zone_notify(current_zone, yyvsp[0].num);
	}
break;
case 189:
#line 1176 "ns_parser.y"
{
		/* nothing */
	}
break;
case 190:
#line 1180 "ns_parser.y"
{
		/* nothing */
	}
break;
case 191:
#line 1186 "ns_parser.y"
{
	  	add_zone_master(current_zone, yyvsp[0].ip_addr);
	}
break;
case 192:
#line 1196 "ns_parser.y"
{
		if (yyvsp[0].num < 0 || yyvsp[0].num > 65535) {
		  	parser_warning(0, 
			  "invalid IP port number '%d'; setting port to 0",
			               yyvsp[0].num);
			yyvsp[0].num = 0;
		} else
			yyval.us_int = htons(yyvsp[0].num);
	}
break;
#line 2182 "y.tab.c"
    }
    yystk.ssp -= yym;
    yystate = *yystk.ssp;
    yystk.vsp -= yym;
    yym = yylhs[yyn];
    yych = yychar;
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystk.ssp = YYFINAL;
        *++yystk.vsp = yyval;
        if (yych < 0)
        {
            if ((yych = YYLEX) < 0) yych = 0;
            yychar = yych;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yych <= YYMAXTOKEN) yys = yyname[yych];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yych, yys);
            }
#endif
        }
        if (yych == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystk.ssp, yystate);
#endif
    if (yystk.ssp >= yystk.sslim && yygrowstack(&yystk))
        goto yyoverflow;
    *++yystk.ssp = yystate;
    *++yystk.vsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    YYFREESTACK(&yystk);
    return (1);
yyaccept:
    YYFREESTACK(&yystk);
    return (0);
}
