///////////////
///////////////
///////////////   THIS FILE IS AUTOMATICALLY GENERATED BY gen-rdatacode.py.
///////////////   DO NOT EDIT!
///////////////
///////////////

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id$

#ifndef __ANY_TSIG_250_H
#define __ANY_TSIG_250_H 1

#include <stdint.h>

#include <string>

#include <dns/rdata.h>

namespace isc {
namespace dns {
class Name;
}
}

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace any {

/// \brief \c rdata::TSIG class represents the TSIG RDATA as defined %in
/// RFC2845.
///
/// This class implements the basic interfaces inherited from the abstract
/// \c rdata::Rdata class, and provides trivial accessors specific to the
/// TSIG RDATA.
class TSIG : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit TSIG(const std::string& type_str);
    TSIG(InputBuffer& buffer, size_t rdata_len);
    TSIG(const TSIG& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    /// \brief Constructor from RDATA field parameters.
    ///
    /// The parameters are a straightforward mapping of %TSIG RDATA
    /// fields as defined %in RFC2845, but there are some implementation
    /// specific notes as follows.
    ///
    /// \c algorithm is a \c Name object that specifies the algorithm.
    /// For example, if the algorithm is HMAC-SHA256, \c algorithm would be
    /// \c Name("hmac-sha256").
    ///
    /// \c time_signed corresponds to the Time Signed field, which is of
    /// 48-bit unsigned integer type, and therefore cannot exceed 2^48-1;
    /// otherwise, an exception of type \c OutOfRange will be thrown.
    ///
    /// \c mac_size and \c mac correspond to the MAC Size and MAC fields,
    /// respectively.  When the MAC field is empty, \c mac must be NULL.
    /// \c mac_size and \c mac must be consistent %in that \c mac_size is 0 if
    /// and only if \c mac is NULL; otherwise an exception of type
    /// InvalidParameter will be thrown.
    ///
    /// The same restriction applies to \c other_len and \c other_data,
    /// which correspond to the Other Len and Other Data fields, respectively.
    ///
    /// This constructor internally involves resource allocation, and if
    /// it fails, a corresponding standard exception will be thrown.
    TSIG(const Name& algorithm, uint64_t time_signed, uint16_t fudge,
         uint16_t mac_size, const void* mac, uint16_t original_id,
         uint16_t error, uint16_t other_len, const void* other_data);

    /// \brief Assignment operator.
    ///
    /// It internally allocates a resource, and if it fails a corresponding
    /// standard exception will be thrown.
    /// This operator never throws an exception otherwise.
    ///
    /// This operator provides the strong exception guarantee: When an
    /// exception is thrown the content of the assignment target will be
    /// intact.
    TSIG& operator=(const TSIG& source);

    /// \brief The destructor.
    ~TSIG();

    /// \brief Return the algorithm name.
    ///
    /// This method never throws an exception.
    const Name& getAlgorithm() const;

    /// \brief Return the value of the Time Signed field.
    ///
    /// The returned value does not exceed 2^48-1.
    ///
    /// This method never throws an exception.
    uint64_t getTimeSigned() const;

    /// \brief Return the value of the Fudge field.
    ///
    /// This method never throws an exception.
    uint16_t getFudge() const;

    /// \brief Return the value of the MAC Size field.
    ///
    /// This method never throws an exception.
    uint16_t getMACSize() const;

    /// \brief Return the value of the MAC field.
    ///
    /// If the MAC field is empty, it returns NULL.
    /// Otherwise, the memory region beginning at the address returned by
    /// this method is valid up to the bytes specified by the return value
    /// of \c getMACSize().
    /// The memory region is only valid while the corresponding \c TSIG
    /// object is valid.  The caller must hold the \c TSIG object while
    /// it needs to refer to the region or it must make a local copy of the
    /// region.
    ///
    /// This method never throws an exception.
    const void* getMAC() const;

    /// \brief Return the value of the Original ID field.
    ///
    /// This method never throws an exception.
    uint16_t getOriginalID() const;

    /// \brief Return the value of the Error field.
    ///
    /// This method never throws an exception.
    uint16_t getError() const;

    /// \brief Return the value of the Other Len field.
    ///
    /// This method never throws an exception.
    uint16_t getOtherLen() const;

    /// \brief Return the value of the Other Data field.
    ///
    /// The same note as \c getMAC() applies.
    ///
    /// This method never throws an exception.
    const void* getOtherData() const;
private:
    struct TSIGImpl;
    TSIGImpl* impl_;
};

} // end of namespace "any"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __ANY_TSIG_250_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: aaaa_28.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __IN_AAAA_28_H
#define __IN_AAAA_28_H 1

#include <stdint.h>

#include <string>

#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace in {

class AAAA : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit AAAA(const std::string& type_str);
    AAAA(InputBuffer& buffer, size_t rdata_len);
    AAAA(const AAAA& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    // notyet:
    //const struct in6_addr& getAddress() const { return (addr_); }
private:
    uint8_t addr_[16];        // raw IPv6 address (network byte order)
};

} // end of namespace "in"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __IN_AAAA_28_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: rdata.h 545 2010-01-27 00:33:28Z jinmei $

#ifndef __IN_A_1_H
#define __IN_A_1_H 1

#include <string>

#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace in {

class A : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit A(const std::string& type_str);
    A(InputBuffer& buffer, size_t rdata_len);
    A(const A& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    //We can use the default destructor.
    //virtual ~A() {}
    // notyet:
    //const struct in_addr& getAddress() const { return (addr_); }
private:
    uint32_t addr_;             // raw IPv4 address (network byte order)
};
} // end of namespace "in"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __IN_A_1_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: a_1.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __CH_A_1_H
#define __CH_A_1_H 1

#include <string>

#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace ch {

class A : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit A(const std::string& type_str);
    A(InputBuffer& buffer, size_t rdata_len);
    A(const A& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
};

} // end of namespace "ch"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __CH_A_1_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: mx_15.h 3224 2010-10-15 08:28:59Z jinmei $

#ifndef __GENERIC_MX_15_H
#define __GENERIC_MX_15_H 1

#include <stdint.h>

#include <string>

#include <dns/name.h>
#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class MX : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit MX(const std::string& type_str);
    MX(InputBuffer& buffer, size_t rdata_len);
    MX(const MX& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    MX(uint16_t preference, const Name& mxname);

    ///
    /// Specialized methods
    ///
    const Name& getMXName() const;
    uint16_t getMXPref() const;

private:
    /// Note: this is a prototype version; we may reconsider
    /// this representation later.
    uint16_t preference_;
    Name mxname_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_MX_15_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: rrsig_46.h 1705 2010-04-12 22:53:37Z jinmei $

#include <stdint.h>

#include <string>

#include <dns/name.h>
#include <dns/rrtype.h>
#include <dns/rrttl.h>
#include <dns/rdata.h>

#ifndef __GENERIC_RRSIG_46_H
#define __GENERIC_RRSIG_46_H 1

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

struct RRSIGImpl;

class RRSIG : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit RRSIG(const std::string& type_str);
    RRSIG(InputBuffer& buffer, size_t rdata_len);
    RRSIG(const RRSIG& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    RRSIG& operator=(const RRSIG& source);
    ~RRSIG();
private:
    RRSIGImpl* impl_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_RRSIG_46_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: dname_39.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __GENERIC_DNAME_39_H
#define __GENERIC_DNAME_39_H 1

#include <string>

#include <dns/name.h>
#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class DNAME : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit DNAME(const std::string& type_str);
    DNAME(InputBuffer& buffer, size_t rdata_len);
    DNAME(const DNAME& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    // DNAME specific methods
    DNAME(const Name& dname);
    const Name& getDname() const;
private:
    Name dname_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_DNAME_39_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: rdata.h 545 2010-01-27 00:33:28Z jinmei $

#ifndef __GENERIC_NS_2_H
#define __GENERIC_NS_2_H 1

#include <string>

#include <dns/name.h>
#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class NS : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit NS(const std::string& type_str);
    NS(InputBuffer& buffer, size_t rdata_len);
    NS(const NS& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    ///
    /// Specialized constructor
    ///
    explicit NS(const Name& nsname) : nsname_(nsname) {}
    ///
    /// Specialized methods
    ///
    const Name& getNSName() const;
private:
    Name nsname_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_NS_2_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: nsec3param_51.h 1705 2010-04-12 22:53:37Z jinmei $

#include <stdint.h>

#include <string>
#include <vector>

#include <dns/name.h>
#include <dns/rrtype.h>
#include <dns/rrttl.h>
#include <dns/rdata.h>

#ifndef __GENERIC_NSEC3PARAM_51_H
#define __GENERIC_NSEC3PARAM_51_H 1

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

struct NSEC3PARAMImpl;

class NSEC3PARAM : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit NSEC3PARAM(const std::string& type_str);
    NSEC3PARAM(InputBuffer& buffer, size_t rdata_len);
    NSEC3PARAM(const NSEC3PARAM& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    NSEC3PARAM& operator=(const NSEC3PARAM& source);
    ~NSEC3PARAM();

    ///
    /// Specialized methods
    ///
    uint8_t getHashalg() const;
    uint8_t getFlags() const;
    uint16_t getIterations() const;
    const std::vector<uint8_t>& getSalt() const;
private:
    NSEC3PARAMImpl* impl_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_NSEC3PARAM_51_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: nsec_47.h 1705 2010-04-12 22:53:37Z jinmei $

#include <stdint.h>

#include <string>

#include <dns/name.h>
#include <dns/rrtype.h>
#include <dns/rrttl.h>
#include <dns/rdata.h>

#ifndef __GENERIC_NSEC_47_H
#define __GENERIC_NSEC_47_H 1

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

struct NSECImpl;

class NSEC : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit NSEC(const std::string& type_str);
    NSEC(InputBuffer& buffer, size_t rdata_len);
    NSEC(const NSEC& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    NSEC& operator=(const NSEC& source);
    ~NSEC();
private:
    NSECImpl* impl_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_NSEC_47_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: opt_41.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __GENERIC_OPT_41_H
#define __GENERIC_OPT_41_H 1

#include <string>

#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class OPT : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit OPT(const std::string& type_str);
    OPT(InputBuffer& buffer, size_t rdata_len);
    OPT(const OPT& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    // The default constructor makes sense for OPT as it can be empty.
    OPT() {}
private:
    // RR-type specific members are here.
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_OPT_41_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: cname_5.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __GENERIC_CNAME_5_H
#define __GENERIC_CNAME_5_H 1

#include <string>

#include <dns/name.h>
#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class CNAME : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit CNAME(const std::string& type_str);
    CNAME(InputBuffer& buffer, size_t rdata_len);
    CNAME(const CNAME& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    // CNAME specific methods
    CNAME(const Name& cname);
    const Name& getCname() const;
private:
    Name cname_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_CNAME_5_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: ptr_12.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __GENERIC_PTR_12_H
#define __GENERIC_PTR_12_H 1

#include <string>

#include <dns/name.h>
#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class PTR : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit PTR(const std::string& type_str);
    PTR(InputBuffer& buffer, size_t rdata_len);
    PTR(const PTR& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    ///
    /// Specialized constructor
    ///
    explicit PTR(const Name& ptr_name) : ptr_name_(ptr_name) {}
    ///
    /// Specialized methods
    ///
    const Name& getPTRName() const;
private:
    Name ptr_name_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_PTR_12_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: soa_6.h 3224 2010-10-15 08:28:59Z jinmei $

#ifndef __GENERIC_SOA_6_H
#define __GENERIC_SOA_6_H 1

#include <string>

#include <dns/name.h>
#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class SOA : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit SOA(const std::string& type_str);
    SOA(InputBuffer& buffer, size_t rdata_len);
    SOA(const SOA& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS

    SOA(const Name& mname, const Name& rname, uint32_t serial,
        uint32_t refresh, uint32_t retry, uint32_t expire,
        uint32_t minimum);
private:
    /// Note: this is a prototype version; we may reconsider
    /// this representation later.
    Name mname_;
    Name rname_;
    /// serial, refresh, retry, expire, minimum, stored in network byte order
    uint8_t numdata_[20];
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_SOA_6_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: dnskey_48.h 1705 2010-04-12 22:53:37Z jinmei $

#include <stdint.h>

#include <string>

#include <dns/name.h>
#include <dns/rrtype.h>
#include <dns/rrttl.h>
#include <dns/rdata.h>

#ifndef __GENERIC_DNSKEY_48_H
#define __GENERIC_DNSKEY_48_H 1

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

struct DNSKEYImpl;

class DNSKEY : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit DNSKEY(const std::string& type_str);
    DNSKEY(InputBuffer& buffer, size_t rdata_len);
    DNSKEY(const DNSKEY& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    DNSKEY& operator=(const DNSKEY& source);
    ~DNSKEY();

    ///
    /// Specialized methods
    ///
    uint16_t getTag() const;
    uint16_t getFlags() const;
    uint8_t getAlgorithm() const;

private:
    DNSKEYImpl* impl_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_DNSKEY_48_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: ds_43.h 1705 2010-04-12 22:53:37Z jinmei $

#include <stdint.h>

#include <string>

#include <dns/name.h>
#include <dns/rrtype.h>
#include <dns/rrttl.h>
#include <dns/rdata.h>

#ifndef __GENERIC_DS_43_H
#define __GENERIC_DS_43_H 1

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

struct DSImpl;

class DS : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit DS(const std::string& type_str);
    DS(InputBuffer& buffer, size_t rdata_len);
    DS(const DS& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    DS& operator=(const DS& source);
    ~DS();

    ///
    /// Specialized methods
    ///
    uint16_t getTag() const;
private:
    DSImpl* impl_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_DS_43_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: nsec_47.h 991 2010-02-26 08:53:26Z jinmei $

#include <stdint.h>

#include <string>
#include <vector>

#include <dns/name.h>
#include <dns/rrtype.h>
#include <dns/rrttl.h>
#include <dns/rdata.h>

#ifndef __GENERIC_NSEC3_50_H
#define __GENERIC_NSEC3_50_H 1

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

struct NSEC3Impl;

class NSEC3 : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit NSEC3(const std::string& type_str);
    NSEC3(InputBuffer& buffer, size_t rdata_len);
    NSEC3(const NSEC3& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
    NSEC3& operator=(const NSEC3& source);
    ~NSEC3();

    uint8_t getHashalg() const;
    uint8_t getFlags() const;
    uint16_t getIterations() const;
    std::vector<uint8_t>& getSalt() const;

private:
    NSEC3Impl* impl_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_NSEC3_50_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: txt_16.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __GENERIC_TXT_16_H
#define __GENERIC_TXT_16_H 1

#include <stdint.h>

#include <string>
#include <vector>

#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace generic {

class TXT : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit TXT(const std::string& type_str);
    TXT(InputBuffer& buffer, size_t rdata_len);
    TXT(const TXT& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
private:
    /// Note: this is a prototype version; we may reconsider
    /// this representation later.
    std::vector<std::vector<uint8_t> > string_list_;
};

} // end of namespace "generic"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __GENERIC_TXT_16_H

// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: a_1.h 1705 2010-04-12 22:53:37Z jinmei $

#ifndef __HS_A_1_H
#define __HS_A_1_H 1

#include <string>

#include <dns/rdata.h>

namespace isc {
namespace dns {

// BEGIN_COMMON_DECLARATIONS

class InputBuffer;
class OutputBuffer;
class MessageRenderer;

// END_COMMON_DECLARATIONS

namespace rdata {
namespace hs {

class A : public Rdata {
public:
    // BEGIN_COMMON_MEMBERS

    explicit A(const std::string& type_str);
    A(InputBuffer& buffer, size_t rdata_len);
    A(const A& other);
    virtual std::string toText() const;
    virtual void toWire(OutputBuffer& buffer) const;
    virtual void toWire(MessageRenderer& renderer) const;
    virtual int compare(const Rdata& other) const;

    // END_COMMON_MEMBERS
};

} // end of namespace "hs"
} // end of namespace "rdata"
} // end of namespace "dns"
} // end of namespace "isc"
#endif // __HS_A_1_H


// Local Variables:
// mode: c++
// End:
