// $Id: roe_tcl.hh 1.4.1.1 Tue, 19 Aug 1997 14:51:42 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef ROE_TCL_H
#define ROE_TCL_H

#include "config.hh"
extern "C" {
#include <tcl.h>
#include <tk.h>
}

extern Tcl_Interp *interp; 

void tcl_Eval(char *format, ...);
void tcl_EvalFile(char *file);
void tcl_delete_blank_lines(char *w);
void tcl_delete_matching_lines(char *w, char *expr);

void roe_initialize_GUI();

extern int roe_show_reg_no;
extern int roe_show_reg_single;
extern int roe_show_reg_multi;
extern int roe_show_reg_undet;
extern int roe_show_routed_no;
extern int roe_show_routed_yes;
extern int roe_show_routed_undet;
extern int roe_show_homed_you;
extern int roe_show_homed_other;
extern int roe_show_homed_multi_me;
extern int roe_show_homed_multi_other;
extern int roe_show_homed_undet;
extern int roe_show_potential_IBGP;

#endif // ROE_TCL_H
